//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AggregateDecl.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 23:56:39 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jun 13 08:12:49 2015
// Update Count     : 6
//

#include "Declaration.h"
#include "Type.h"
#include "Common/utility.h"


AggregateDecl::AggregateDecl( const std::string &name ) : Parent( name, DeclarationNode::NoStorageClass, LinkageSpec::Cforall ) {
}

AggregateDecl::AggregateDecl( const AggregateDecl &other ) : Parent( other ) {
	cloneAll( other.members, members );
	cloneAll( other.parameters, parameters );
}

AggregateDecl::~AggregateDecl() {
	deleteAll( members );
	deleteAll( parameters );
}

void AggregateDecl::print( std::ostream &os, int indent ) const {
	using std::string;
	using std::endl;

	os << typeString() << " " << get_name();
	if ( ! parameters.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent+4 );
	} // if
	if ( ! members.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with members" << endl;
		printAll( members, os, indent+4 );
	} // if
}

void AggregateDecl::printShort( std::ostream &os, int indent ) const {
	using std::string;
	using std::endl;

	os << typeString() << " " << get_name();
	if ( ! parameters.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent+4 );
	} // if
}

std::string StructDecl::typeString() const { return "struct"; }

std::string UnionDecl::typeString() const { return "union"; }

std::string EnumDecl::typeString() const { return "enum"; }

std::string ContextDecl::typeString() const { return "context"; }

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
