//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Unify.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 13:09:04 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 13:10:34 2015
// Update Count     : 2
//

#ifndef UNIFY_H
#define UNIFY_H

#include <map>
#include <list>
#include "SynTree/SynTree.h"
#include "SynTree/Type.h"
#include "SynTree/Declaration.h"
#include "SymTab/Indexer.h"
#include "TypeEnvironment.h"
#include "Common/utility.h"

namespace ResolvExpr {
	bool unify( Type *type1, Type *type2, TypeEnvironment &env, AssertionSet &needAssertions, AssertionSet &haveAssertions, OpenVarSet &openVars, const SymTab::Indexer &indexer );
	bool unify( Type *type1, Type *type2, TypeEnvironment &env, AssertionSet &needAssertions, AssertionSet &haveAssertions, OpenVarSet &openVars, const SymTab::Indexer &indexer, Type *&commonType );
	bool unifyExact( Type *type1, Type *type2, TypeEnvironment &env, AssertionSet &needAssertions, AssertionSet &haveAssertions, OpenVarSet &openVars, const SymTab::Indexer &indexer );

	template< typename Iterator1, typename Iterator2 >
	bool unifyList( Iterator1 list1Begin, Iterator1 list1End, Iterator2 list2Begin, Iterator2 list2End, TypeEnvironment &env, AssertionSet &needAssertions, AssertionSet &haveAssertions, OpenVarSet &openVars, const SymTab::Indexer &indexer, std::list< Type* > &commonTypes ) {
		for ( ; list1Begin != list1End && list2Begin != list2End; ++list1Begin, ++list2Begin ) {
			Type *commonType = 0;
			if ( ! unify( *list1Begin, *list2Begin, env, needAssertions, haveAssertions, openVars, indexer, commonType ) ) {
				return false;
			} // if
			commonTypes.push_back( commonType );
		} // for
		if ( list1Begin != list1End || list2Begin != list2End ) {
			return false;
		} else {
			return true;
		} // if
	}

	template< typename Iterator1, typename Iterator2 >
	bool unifyList( Iterator1 list1Begin, Iterator1 list1End, Iterator2 list2Begin, Iterator2 list2End, TypeEnvironment &env, AssertionSet &needAssertions, AssertionSet &haveAssertions, OpenVarSet &openVars, const SymTab::Indexer &indexer ) {
		std::list< Type* > commonTypes;
		if ( unifyList( list1Begin, list1End, list2Begin, list2End, env, needAssertions, haveAssertions, openVars, indexer, commonTypes ) ) {
			deleteAll( commonTypes );
			return true;
		} else {
			return false;
		} // if
	}

} // namespace ResolvExpr

#endif // UNIFY_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
