//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// InitExpander.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:34:12 2015
// Update Count     : 1
//

#include <list>
#include <stack>
#include <cassert>
#include <algorithm>

#include "Common/utility.h"
#include "InitExpander.h"
#include "InitModel.h"

namespace InitTweak {
	InitExpander::InitExpander() {}

	InitExpander::~InitExpander() {}

	ObjectDecl *InitExpander::mutate( ObjectDecl *objectDecl ) {
		index.visit( objectDecl );

		if ( objectDecl->get_init() == 0 ) return objectDecl;

		InitModelBuilder builder( objectDecl );
		builder.get_assoc()->display( std::cerr ); // xxx
		InitModelFiller filler( builder.get_assoc(), objectDecl->get_init(), true );
		// filler.get_assoc()->display( std::cerr ); // xxx
		InitUnspooler exp;
		filler.get_assoc()->accept( exp );
		objectDecl->set_init( exp.grab_initializer() );
		objectDecl->get_init()->print( std::cerr );

		return objectDecl;
	}
} // namespace InitTweak

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
