//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LabelTypeChecker.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jan 25 21:22:30 2016
// Update Count     : 4
//

#ifndef LABEL_TYPE_H
#define LABEL_TYPE_H

#include "SynTree/Visitor.h"
#include "SymTab/Indexer.h"
#include "SynTree/Statement.h"

#include "Common/utility.h"

namespace ControlStruct {
	class LabelTypeChecker : public Visitor {
	  public:
		//LabelTypeChecker() {

		virtual void visit( CompoundStmt *compoundStmt );
		virtual void visit( DeclStmt *declStmt );
		virtual void visit( BranchStmt *branchStmt );
		virtual void visit( UntypedExpr *untypedExpr );
	  private:
		SymTab::Indexer index;
	};
} // namespace ControlStruct

#endif // LABEL_TYPE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
