//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TupleType.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 11:00:01 2015
// Update Count     : 2
//

#include "Type.h"
#include "Common/utility.h"

TupleType::TupleType( const Type::Qualifiers &tq ) : Type( tq ) {
}

TupleType::TupleType( const TupleType& other ) : Type( other ) {
	cloneAll( other.types, types );
}

TupleType::~TupleType() {
	deleteAll( types );
}

void TupleType::print( std::ostream &os, int indent ) const {
	Type::print( os, indent );
	os << "tuple of types" << std::endl;
	printAll( types, os, indent+2 );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
