//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FunctionType.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 09:01:28 2015
// Update Count     : 1
//

#include <algorithm>

#include "Type.h"
#include "Declaration.h"
#include "Common/utility.h"

FunctionType::FunctionType( const Type::Qualifiers &tq, bool isVarArgs ) : Type( tq ), isVarArgs( isVarArgs ) {
}

FunctionType::FunctionType( const FunctionType &other ) : Type( other ), isVarArgs( other.isVarArgs ) {
	cloneAll( other.returnVals, returnVals );
	cloneAll( other.parameters, parameters );
}

FunctionType::~FunctionType() {
	deleteAll( returnVals );
	deleteAll( parameters );
}

void FunctionType::print( std::ostream &os, int indent ) const {
	using std::string;
	using std::endl;

	Type::print( os, indent );
	os << "function" << endl;
	if ( ! parameters.empty() ) {
		os << string( indent + 2, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent + 4 );
		if ( isVarArgs ) {
			os << string( indent + 4, ' ' ) << "and a variable number of other arguments" << endl;
		} // if
	} else if ( isVarArgs ) {
		os << string( indent + 4, ' ' ) << "accepting unspecified arguments" << endl;
	} // if
	os << string( indent + 2, ' ' ) << "returning ";
	if ( returnVals.empty() ) {
		os << endl << string( indent + 4, ' ' ) << "nothing " << endl;
	} else {
		os << endl;
		printAll( returnVals, os, indent + 4 );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
