//
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Debug.h --
//
// Author           : Rob Schluntz
// Created On       : Fri Sep 1 11:09:14 2017
// Last Modified By : Rob Schluntz
// Last Modified On : Fri Sep 1 11:09:36 2017
// Update Count     : 2
//

#pragma once

#include <string>
#include <list>
#include <iostream>

#include "CodeGen/Generate.h"
#include "Parser/LinkageSpec.h"
#include "SynTree/Declaration.h"

#define DEBUG

namespace Debug {
	/// debug codegen a translation unit
	static inline void codeGen( __attribute__((unused)) const std::list< Declaration * > & translationUnit, __attribute__((unused)) const std::string & label, LinkageSpec::Spec linkageFilter = LinkageSpec::Compiler ) {
	#ifdef DEBUG
		std::list< Declaration * > decls;

		filter( translationUnit.begin(), translationUnit.end(), back_inserter( decls ), [linkageFilter]( Declaration * decl ) {
			return ! (decl->linkage & linkageFilter);
		});

		std::cerr << "======" << label << "======" << std::endl;
		CodeGen::generate( decls, std::cerr, true, true );
	#endif
	} // dump

	static inline void treeDump( __attribute__((unused)) const std::list< Declaration * > & translationUnit, __attribute__((unused)) const std::string & label, LinkageSpec::Spec linkageFilter = LinkageSpec::Compiler ) {
	#ifdef DEBUG
		std::list< Declaration * > decls;

		filter( translationUnit.begin(), translationUnit.end(), back_inserter( decls ), [linkageFilter]( Declaration * decl ) {
			return ! (decl->linkage & linkageFilter);
		});

		std::cerr << "======" << label << "======" << std::endl;
		printAll( decls, std::cerr );
	#endif
	} // dump
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
