//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mutate.cc --
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 12 17:37:45 2016
// Update Count     : 8
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <list>

#include "Mutate.h"
#include "LabelFixer.h"
#include "MLEMutator.h"
#include "CaseRangeMutator.h"
#include "ForExprMutator.h"
#include "LabelTypeChecker.h"
//#include "ExceptMutator.h"

#include "Common/utility.h"

#include "SynTree/Visitor.h"

using namespace std;

namespace ControlStruct {
	void mutate( std::list< Declaration * > translationUnit ) {
		// hoist initialization out of for statements
		ForExprMutator formut;

		// normalizes label definitions and generates multi-level exit labels
		LabelFixer lfix;

		// expand case ranges and turn fallthru into a null statement
		CaseRangeMutator ranges;

		//ExceptMutator exc;
		// LabelTypeChecker lbl;

		mutateAll( translationUnit, formut );
		acceptAll( translationUnit, lfix );
		mutateAll( translationUnit, ranges );
		//mutateAll( translationUnit, exc );
		//acceptAll( translationUnit, lbl );
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
