//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// square.c --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec 11 23:28:24 2018
// Update Count     : 28
//

#include <fstream.hfa>

forall( T | { T ?*?( T, T ); } )
T square( T t ) {
	return t * t;
} // square

int main() {
#if 0
	sout | "result of squaring 9 is ";

	// char does not have multiplication.
	char ?*?( char a1, char a2 ) {
		return (char)((int)a1 * (int)a2);
	} // ?*?
	char c = 9;
	sout | "char\t\t\t" | square( c );

	sout | square( s );
#endif
	short s = 9;
	square( s );
#if 0
	signed int i = 9;
	sout | "signed int\t\t" | square( i );

	unsigned int ui = 9;
	sout | "unsigned int\t\t" | square( ui );

	long int li = 9;
	sout | "signed long int\t\t" | square( li );

	unsigned long int uli = 9;
	sout | "unsigned long int\t" | square( uli );

	signed long long int lli = 9;
	sout | "signed long long int\t" | square( lli );

	unsigned long long int ulli = 9;
	sout | "unsigned long long int\t" | square( ulli );

	float f = 9.0;
	sout | "float\t\t\t" | square( f );

	double d = 9.0;
	sout | "double\t\t\t" | square( d );

	long double ld = 9.0;
	sout | "long double\t\t" | square( ld );
#endif
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa square.c" //
// End: //
