#ifndef TYPEDATA_H
#define TYPEDATA_H

#include <list>
#include "ParseNode.h"
#include "SynTree/SynTree.h"
#include "SynTree/Type.h"
#include "SynTree/Declaration.h"
#include "SemanticError.h"
#include "LinkageSpec.h"

struct TypeData {
    enum Kind { Unknown, Basic, Pointer, Array, Function, Aggregate, AggregateInst,
		Enum, EnumConstant, Symbolic, SymbolicInst, Variable, Tuple, Typeof, Attr } kind;

    TypeData( Kind k = Unknown );
    ~TypeData();
    void print( std::ostream &, int indent = 0 ) const;
    TypeData *clone() const;

    Type *build() const;
    FunctionType *buildFunction() const;

    TypeData *base;
    std::list< DeclarationNode::Qualifier > qualifiers;
    DeclarationNode *forall;

    struct Basic_t {
	std::list< DeclarationNode::BasicType > typeSpec;
	std::list< DeclarationNode::Modifier > modifiers;
    };

    struct Aggregate_t {
	DeclarationNode::TyCon kind;
	std::string name;
	DeclarationNode *params;
	ExpressionNode *actuals;			// holds actual parameters later applied to AggInst
	DeclarationNode *members;
    };

    struct AggInst_t {
	TypeData *aggregate;
	ExpressionNode *params;
    };

    struct Array_t {
	ExpressionNode *dimension;
	bool isVarLen;
	bool isStatic;
    };

    struct Enumeration_t {
	std::string name;
	DeclarationNode *constants;
    };

    struct Function_t {
	DeclarationNode *params;
	DeclarationNode *idList;			// old-style
	DeclarationNode *oldDeclList;
	StatementNode *body;
	bool hasBody;
	bool newStyle;
    };

    struct Symbolic_t {
	std::string name;
	bool isTypedef;
	DeclarationNode *params;
	ExpressionNode *actuals;
	DeclarationNode *assertions;
    };

    struct Variable_t {
	DeclarationNode::TypeClass tyClass;
	std::string name;
	DeclarationNode *assertions;
    };

    struct Tuple_t {
	DeclarationNode *members;
    };
  
    struct Typeof_t {
	ExpressionNode *expr;
    };

    struct Attr_t {
	std::string name;
	ExpressionNode *expr;
	DeclarationNode *type;
    };

    union {
	Basic_t *basic;
	Aggregate_t *aggregate;
	AggInst_t *aggInst;
	Array_t *array;
	Enumeration_t *enumeration;
	Function_t *function;
	Symbolic_t *symbolic;
	Variable_t *variable;
	Tuple_t *tuple;
	Typeof_t *typeexpr;
	Attr_t *attr;
    };

    TypeData *extractAggregate( bool toplevel = true ) const;
    // helper function for DeclNodeImpl::build
    Declaration * buildDecl( std::string name, Declaration::StorageClass sc, Expression *bitfieldWidth, bool isInline, LinkageSpec::Type linkage, Initializer *init = 0 ) const;
    // helper functions for build()
    Type::Qualifiers buildQualifiers() const;
    Type *buildBasicType() const;
    PointerType * buildPointer() const;
    ArrayType * buildArray() const;
    AggregateDecl * buildAggregate() const;
    ReferenceToType * buildAggInst() const;
    NamedTypeDecl * buildSymbolic( const std::string &name, Declaration::StorageClass sc ) const;
    TypeDecl* buildVariable() const;
    EnumDecl* buildEnum() const;
    TypeInstType * buildSymbolicInst() const;
    TupleType * buildTuple() const;
    TypeofType * buildTypeof() const;
    AttrType * buildAttr() const;
};

#endif // TYPEDATA_H
