//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Visitor.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 17 15:39:38 2017
// Update Count     : 29
//

#include <cassert>        // for assert
#include <list>           // for list

#include "Attribute.h"    // for Attribute
#include "Constant.h"     // for Constant
#include "Declaration.h"  // for DeclarationWithType, ObjectDecl, Declaration
#include "Expression.h"   // for Expression, ConstantExpr, ImplicitCopyCtorExpr
#include "Initializer.h"  // for Initializer, Designation, ConstructorInit
#include "Statement.h"    // for Statement, CatchStmt, AsmStmt, CompoundStmt
#include "Type.h"         // for Type, Type::ForallList, AttrType, FunctionType
#include "Visitor.h"

class Subrange;

Visitor::Visitor() {}

Visitor::~Visitor() {}

void Visitor::visit( TupleType *tupleType ) {
	acceptAll( tupleType->get_forall(), *this );
	acceptAll( tupleType->get_types(), *this );
	acceptAll( tupleType->get_members(), *this );
}

void Visitor::visit( TypeofType *typeofType ) {
	assert( typeofType->get_expr() );
	typeofType->get_expr()->accept( *this );
}

void Visitor::visit( AttrType *attrType ) {
	if ( attrType->get_isType() ) {
		assert( attrType->get_type() );
		attrType->get_type()->accept( *this );
	} else {
		assert( attrType->get_expr() );
		attrType->get_expr()->accept( *this );
	} // if
}

void Visitor::visit( VarArgsType *varArgsType ) {
	acceptAll( varArgsType->get_forall(), *this );
}

void Visitor::visit( ZeroType *zeroType ) {
	acceptAll( zeroType->get_forall(), *this );
}

void Visitor::visit( OneType *oneType ) {
	acceptAll( oneType->get_forall(), *this );
}

void Visitor::visit( Designation * designation ) {
	acceptAll( designation->get_designators(), *this );
}

void Visitor::visit( SingleInit *singleInit ) {
	singleInit->get_value()->accept( *this );
}

void Visitor::visit( ListInit *listInit ) {
	acceptAll( listInit->get_designations(), *this );
	acceptAll( listInit->get_initializers(), *this );
}

void Visitor::visit( ConstructorInit *ctorInit ) {
	maybeAccept( ctorInit->get_ctor(), *this );
	maybeAccept( ctorInit->get_dtor(), *this );
	maybeAccept( ctorInit->get_init(), *this );
}


void Visitor::visit( Subrange * ) {}


void Visitor::visit( Constant * ) {}

void Visitor::visit( Attribute * attribute ) {
	acceptAll( attribute->parameters, *this );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
