//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mutator.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 17 15:39:37 2017
// Update Count     : 27
//

#include <cassert>             // for assert
#include <list>                // for list

#include "Attribute.h"         // for Attribute
#include "Declaration.h"       // for ObjectDecl, Declaration, DeclarationWi...
#include "Expression.h"        // for Expression, ConstantExpr, ConditionalExpr
#include "Initializer.h"       // for ConstructorInit, Initializer, Designation
#include "Mutator.h"
#include "Statement.h"         // for Statement, CatchStmt, AsmStmt, ForStmt
#include "Type.h"              // for Type, Type::ForallList, AttrType, Arra...
#include "TypeSubstitution.h"  // for TypeSubstitution

class Constant;
class Subrange;

Mutator::Mutator() {}

Mutator::~Mutator() {}

Type * Mutator::mutate( TupleType *tupleType ) {
	mutateAll( tupleType->get_forall(), *this );
	mutateAll( tupleType->get_types(), *this );
	mutateAll( tupleType->get_members(), *this );
	return tupleType;
}

Type * Mutator::mutate( TypeofType *typeofType ) {
	assert( typeofType->get_expr() );
	typeofType->set_expr( typeofType->get_expr()->acceptMutator( *this ) );
	return typeofType;
}

Type * Mutator::mutate( AttrType *attrType ) {
	if ( attrType->get_isType() ) {
		assert( attrType->get_type() );
		attrType->set_type( attrType->get_type()->acceptMutator( *this ) );
	} else {
		assert( attrType->get_expr() );
		attrType->set_expr( attrType->get_expr()->acceptMutator( *this ) );
	}
	return attrType;
}

Type * Mutator::mutate( VarArgsType *varArgsType ) {
	mutateAll( varArgsType->get_forall(), *this );
	return varArgsType;
}

Type * Mutator::mutate( ZeroType *zeroType ) {
	mutateAll( zeroType->get_forall(), *this );
	return zeroType;
}

Type * Mutator::mutate( OneType *oneType ) {
	mutateAll( oneType->get_forall(), *this );
	return oneType;
}


Designation * Mutator::mutate( Designation * designation ) {
	mutateAll( designation->get_designators(), *this );
	return designation;
}

Initializer * Mutator::mutate( SingleInit *singleInit ) {
	singleInit->set_value( singleInit->get_value()->acceptMutator( *this ) );
	return singleInit;
}

Initializer * Mutator::mutate( ListInit *listInit ) {
	mutateAll( listInit->get_designations(), *this );
	mutateAll( listInit->get_initializers(), *this );
	return listInit;
}

Initializer * Mutator::mutate( ConstructorInit *ctorInit ) {
	ctorInit->set_ctor( maybeMutate( ctorInit->get_ctor(), *this ) );
	ctorInit->set_dtor( maybeMutate( ctorInit->get_dtor(), *this ) );
	ctorInit->set_init( maybeMutate( ctorInit->get_init(), *this ) );
	return ctorInit;
}


Subrange * Mutator::mutate( Subrange *subrange ) {
	return subrange;
}


Constant * Mutator::mutate( Constant *constant ) {
	return constant;
}

Attribute * Mutator::mutate( Attribute * attribute ) {
	mutateAll( attribute->parameters, *this );
	return attribute;
}

TypeSubstitution * Mutator::mutate( TypeSubstitution * sub ) {
	for ( auto & p : sub->typeEnv ) {
		p.second = maybeMutate( p.second, *this );
	}
	for ( auto & p : sub->varEnv ) {
		p.second = maybeMutate( p.second, *this );
	}
	return sub;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
