#pragma once

#include "gcpointers.h"
#include "internal/collector.h"

forall(otype T)
static inline gcpointer(T) gcmalloc()
{
    gcpointer(T) ptr;
    void* address = gc_allocate(sizeof(T));
    (&ptr){ address };
    ctor(&ptr, address);
    gc_conditional_collect();
    return ptr;
}
