//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// alloc.c --
//
// Author           : Peter A. Buhr
// Created On       : Wed Feb  3 07:56:22 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jul 25 09:09:43 2018
// Update Count     : 331
//

#include <assert.h>
#include <malloc.h>										// malloc_usable_size
#include <stdint.h>										// uintptr_t
#include <stdlib.h>										// posix_memalign
#include <fstream>
#include <stdlib>										// access C malloc, realloc

int * foo( int * p, int c ) { return p; }
int * bar( int * p, int c ) { return p; }
int * baz( int * p, int c ) { return p; }

int main( void ) {
	size_t dim = 10;
	char fill = '\xff';
	int * p;

	// allocation, non-array types

	// int & r = malloc();
	// r = 0xdeadbeef;
	// printf( "C   malloc %#x\n", r );
	// free( &r );

	p = (int *)malloc( sizeof(*p) );					// C malloc, type unsafe
	*p = 0xdeadbeef;
	printf( "C   malloc %#x\n", *p );
	free( p );

	p = malloc();                                       // CFA malloc, type safe
	*p = 0xdeadbeef;
	printf( "CFA malloc %#x\n", *p );
	free( p );

	p = alloc();                                        // CFA alloc, type safe
	*p = 0xdeadbeef;
	printf( "CFA alloc %#x\n", *p );
	free( p );

	p = alloc( fill );                                  // CFA alloc, fill
	printf( "CFA alloc, fill %08x\n", *p );
	free( p );


	// allocation, array types
	printf( "\n" );

	p = (int *)calloc( dim, sizeof( *p ) );				// C array calloc, type unsafe
	printf( "C   array calloc, fill 0\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );
	free( p );

	p = calloc( dim );                                  // CFA array calloc, type safe
	printf( "CFA array calloc, fill 0\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );
	free( p );

	p = alloc( dim );                                   // CFA array alloc, type safe
	for ( int i = 0; i < dim; i += 1 ) { p[i] = 0xdeadbeef; }
	printf( "CFA array alloc, no fill\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );
	free( p );

	p = alloc( 2 * dim, fill );                         // CFA array alloc, fill
	printf( "CFA array alloc, fill %#hhx\n", fill );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );
	// do not free


	// resize, non-array types
	printf( "\n" );

	p = (int *)realloc( p, dim * sizeof(*p) );			// C realloc
	for ( int i = 0; i < dim; i += 1 ) { p[i] = 0xdeadbeef; }
	printf( "C   realloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );

	p = realloc( p, 2 * dim * sizeof(*p) );             // CFA realloc
	for ( int i = dim; i < 2 * dim; i += 1 ) { p[i] = 0x1010101; }
	printf( "CFA realloc\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );
	// do not free


	// resize, array types
	printf( "\n" );

	p = alloc( p, dim );                                // CFA resize array alloc
	for ( int i = 0; i < dim; i += 1 ) { p[i] = 0xdeadbeef; }
	printf( "CFA resize alloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );

	p = alloc( p, 2 * dim );                            // CFA resize array alloc
	for ( int i = dim; i < 2 * dim; i += 1 ) { p[i] = 0x1010101; }
	printf( "CFA resize array alloc\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );

	p = alloc( p, dim );                                // CFA array alloc
	printf( "CFA resize array alloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );

	free( p );
	p = 0;

	p = alloc( p, dim, fill );                          // CFA array alloc, fill
	printf( "CFA resize array alloc, fill\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );

	p = alloc( p, 2 * dim, fill );                      // CFA array alloc, fill
	printf( "CFA resize array alloc, fill\n" );
	for ( int i = 0; i < 2 * dim; i += 1 ) { printf( "%#x ", p[i] ); }
	printf( "\n" );

	p = alloc( p, dim, fill );                          // CFA array alloc, fill
	printf( "CFA resize array alloc, fill\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x ", p[i] );; }
	printf( "\n" );
	free( p );


	struct Struct { int x; double y; };
	Struct st, st1, sta[dim], sta1[dim], * stp, * stp1;

	// alignment, non-array types
	printf( "\n" );
	enum { Alignment = 128 };

	stp = &(*(Struct*)memalign( Alignment, sizeof( *stp ) ) ){ 42, 42.5 }; // C memalign
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "C   memalign %d %g\n", stp->x, stp->y );
	free( stp );

	stp = &(*memalign( Alignment )){ 42, 42.5 };          // CFA memalign
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA memalign %d %g\n", stp->x, stp->y );
	free( stp );

	posix_memalign( (void **)&stp, Alignment, sizeof( *stp ) ); // C posix_memalign
	*stp = (Struct){ 42, 42.5 };
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA posix_memalign %d %g\n", stp->x, stp->y );
	free( stp );

	posix_memalign( &stp, Alignment );                  // CFA posix_memalign
	*stp = (Struct){ 42, 42.5 };
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA posix_memalign %d %g\n", stp->x, stp->y );
	free( stp );

	stp = &(*aligned_alloc( Alignment )){ 42, 42.5 };     // CFA aligned_alloc
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA aligned_alloc %d %g\n", stp->x, stp->y );
	free( stp );

	stp = &(*align_alloc( Alignment )){ 42, 42.5 };       // CFA align_alloc
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA align_alloc %d %g\n", stp->x, stp->y );
	free( stp );

	stp = align_alloc( Alignment, fill );               // CFA memalign, fill
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA align_alloc fill %#x %a\n", stp->x, stp->y );
	free( stp );


	// alignment, array types
	printf( "\n" );

	stp = align_alloc( Alignment, dim );                // CFA array memalign
	assert( (uintptr_t)stp % Alignment == 0 );
	for ( int i = 0; i < dim; i += 1 ) { stp[i] = (Struct){ 42, 42.5 }; }
	printf( "CFA array align_alloc\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%d %g, ", stp[i].x, stp[i].y ); }
	printf( "\n" );
	free( stp );

	stp = align_alloc( Alignment, dim, fill );          // CFA array memalign, fill
	assert( (uintptr_t)stp % Alignment == 0 );
	printf( "CFA array align_alloc, fill\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x %a, ", stp[i].x, stp[i].y ); }
	printf( "\n" );
	free( stp );


	// data, non-array types
	printf( "\n" );

	memset( &st, fill );                                // CFA memset, type safe
	printf( "CFA memset %#x %a\n", st.x, st.y );
	memcpy( &st1, &st );                                // CFA memcpy, type safe
	printf( "CFA memcpy %#x %a\n", st1.x, st1.y );


	// data, array types
	printf( "\n" );

	memset( sta, dim, fill );                           // CFA array memset, type safe
	printf( "CFA array memset\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x %a, ", sta[i].x, sta[i].y ); }
	printf( "\n" );

	memcpy( sta1, sta, dim );                           // CFA array memcpy, type safe
	printf( "CFA memcpy\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%#x %a, ", sta1[i].x, sta1[i].y ); }
	printf( "\n" );


	// new, non-array types
	printf( "\n" );

	stp = new( 42, 42.5 );
	stp1 = new( 42, 42.5 );
	printf( "CFA new initialize\n%d %g %d %g\n", stp->x, stp->y, stp1->x, stp1->y );
	delete( stp, stp1 );

	// new, array types
	stp = anew( dim, 42, 42.5 );
	printf( "CFA array new initialize\n" );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%d %g, ", stp[i].x, stp[i].y ); }
	printf( "\n" );
	stp1 = anew( dim, 42, 42.5 );
	for ( int i = 0; i < dim; i += 1 ) { printf( "%d %g, ", stp1[i].x, stp1[i].y ); }
	printf( "\n" );
	adelete( dim, stp, dim, stp1 );

	// extras
	printf( "\n" );

	float * fp = malloc() + 1;
	printf( "pointer arithmetic %d\n", fp == fp - 1 );
	free( fp - 1 );

	p = foo( bar( baz( malloc(), 0 ), 0 ), 0 );
	*p = 0xdeadbeef;
	printf( "CFA deep malloc %#x\n", *p );
	free( p );

#ifdef ERR1
	stp = malloc();
	printf( "\nSHOULD FAIL\n" );
	p = realloc( stp, dim * sizeof( *stp ) );
	p = alloc( stp, dim * sizeof( *stp ) );
	p = memset( stp, 10 );
	p = memcpy( &st1, &st );
#endif
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa alloc.c" //
// End: //
