#!/usr/bin/env bash

readonly ALL_TESTS=(raise-{empty,detor,finally,other} try-{catch,finally} \
			cond-match-{all,none} fixup-{empty,other})

gen-file-name() (
	if echo "$1" | grep -q -E '^[^%]*%[^%]*$' -; then
		for L in {a..z}; do
			file_name=${1//%/$L}
			if ! [ -e $file_name ]; then
				break
			fi
		done
		echo $file_name
	else
		echo "$1"
	fi
)

readonly N=${1:-1}
readonly OUT_FILE=$(gen-file-name ${2:-run-%-$N})

run-tests() (
	for ((i = 0 ; i < N ; ++i)); do
		for test in ${ALL_TESTS[@]}; do
			for lang in cfa-t cfa-r cpp java python; do
				./test.sh $lang $test
			done
		done
	done
)

run-tests > $OUT_FILE
