//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AddressExpr.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 23:54:44 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Apr 26 12:35:13 2016
// Update Count     : 6
//

#include "Expression.h"
#include "Type.h"
#include "Common/utility.h"

AddressExpr::AddressExpr( Expression *arg, Expression *_aname ) : Expression( _aname ), arg( arg ) {
	if ( arg->has_result() ) {
		if ( ReferenceType * refType = dynamic_cast< ReferenceType * > ( arg->get_result() ) ) {
			// xxx - very temporary, make &ref look like **
			set_result( new PointerType( Type::Qualifiers( Type::Lvalue ), refType->get_base()->clone() ) );
		} else {
			set_result( new PointerType( Type::Qualifiers(), arg->get_result()->clone() ) );
		}
	}
}

AddressExpr::AddressExpr( const AddressExpr &other ) : Expression( other ), arg( maybeClone( other.arg ) ) {
}

AddressExpr::~AddressExpr() {
	delete arg;
}

void AddressExpr::print( std::ostream &os, int indent ) const {
	os << "Address of:" << std::endl;
	if ( arg ) {
		os << std::string( indent+2, ' ' );
		arg->print( os, indent+2 );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
