//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeData.h --
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 15:18:36 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Mar 16 08:32:39 2017
// Update Count     : 185
//

#ifndef TYPEDATA_H
#define TYPEDATA_H

#include "ParseNode.h"
#include "SynTree/Type.h"

struct TypeData {
	enum Kind { Basic, Pointer, Array, Reference, Function, Aggregate, AggregateInst, Enum, EnumConstant, Symbolic,
				SymbolicInst, Tuple, Typeof, Builtin, Unknown };

	struct Aggregate_t {
		DeclarationNode::Aggregate kind;
		const std::string * name;
		DeclarationNode * params;
		ExpressionNode * actuals;						// holds actual parameters later applied to AggInst
		DeclarationNode * fields;
		bool body;
	};

	struct AggInst_t {
		TypeData * aggregate;
		ExpressionNode * params;
		bool hoistType;
	};

	struct Array_t {
		ExpressionNode * dimension;
		bool isVarLen;
		bool isStatic;
	};

	struct Enumeration_t {
		const std::string * name;
		DeclarationNode * constants;
		bool body;
	};

	struct Function_t {
		mutable DeclarationNode * params;				// mutables modified in buildKRFunction
		mutable DeclarationNode * idList;				// old-style
		mutable DeclarationNode * oldDeclList;
		StatementNode * body;
		bool newStyle;
	};

	struct Symbolic_t {
		const std::string * name;
		bool isTypedef;									// false => TYPEGENname, true => TYPEDEFname
		DeclarationNode * params;
		ExpressionNode * actuals;
		DeclarationNode * assertions;
	};

	Kind kind;
	TypeData * base;
	DeclarationNode::BasicType basictype = DeclarationNode::NoBasicType;
	DeclarationNode::ComplexType complextype = DeclarationNode::NoComplexType;
	DeclarationNode::Signedness signedness = DeclarationNode::NoSignedness;
	DeclarationNode::Length length = DeclarationNode::NoLength;
	DeclarationNode::BuiltinType builtintype = DeclarationNode::NoBuiltinType;

	Type::Qualifiers qualifiers;
	DeclarationNode * forall;

	// Basic_t basic;
	Aggregate_t aggregate;
	AggInst_t aggInst;
	Array_t array;
	Enumeration_t enumeration;
	// Variable_t variable;
	Function_t function;
	Symbolic_t symbolic;
	DeclarationNode * tuple;
	ExpressionNode * typeexpr;

	TypeData( Kind k = Unknown );
	~TypeData();
	void print( std::ostream &, int indent = 0 ) const;
	TypeData * clone() const;
};

Type * typebuild( const TypeData * );
TypeData * typeextractAggregate( const TypeData * td, bool toplevel = true );
Type::Qualifiers buildQualifiers( const TypeData * td );
Type * buildBasicType( const TypeData * );
PointerType * buildPointer( const TypeData * );
ArrayType * buildArray( const TypeData * );
ReferenceType * buildReference( const TypeData * );
AggregateDecl * buildAggregate( const TypeData *, std::list< Attribute * > );
ReferenceToType * buildComAggInst( const TypeData *, std::list< Attribute * > attributes );
ReferenceToType * buildAggInst( const TypeData * );
TypeDecl * buildVariable( const TypeData * );
EnumDecl * buildEnum( const TypeData *, std::list< Attribute * > );
TypeInstType * buildSymbolicInst( const TypeData * );
TupleType * buildTuple( const TypeData * );
TypeofType * buildTypeof( const TypeData * );
Declaration * buildDecl( const TypeData *, const std::string &, Type::StorageClasses, Expression *, Type::FuncSpecifiers funcSpec, LinkageSpec::Spec, ConstantExpr *asmName, Initializer * init = nullptr, std::list< class Attribute * > attributes = std::list< class Attribute * >() );
FunctionType * buildFunction( const TypeData * );
void buildKRFunction( const TypeData::Function_t & function );

#endif // TYPEDATA_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
