#include <stdlib.h>
#include <stdio.h>

// code is nested in macros

#define list(N) N ## _list

#define list_insert(N) N ## _list_insert

#define list_head(N) N ## _list_head

#define define_list(N, T) \
	struct list(N) { T value; struct list(N)* next; }; \
	\
	void list_insert(N)( struct list(N)** ls, T x ) { \
		struct list(N)* node = malloc(sizeof(struct list(N))); \
		node->value = x; node->next = *ls; \
		*ls = node; \
	} \
	\
	T list_head(N)( const struct list(N)* ls ) { return ls->value; }

define_list(int, int);  // defines int_list
define_list(string, const char*);  // defines string_list

// use is efficient, but syntactically idiosyncratic

int main() {
	struct list(int)* il = NULL;
	list_insert(int)( &il, 42 );
	printf("%d\n", list_head(int)(il));
	
	struct list(string)* sl = NULL;
	list_insert(string)( &sl, "hello" );
	printf("%s\n", list_head(string)(sl));
}