//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// vector_int.c --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul  5 21:00:56 2016
// Update Count     : 4
//

#include "vector_int.h"
#include <stdlib.h>
#include <assert.h>

#define DEFAULT_CAPACITY 20

void ?{}( vector_int & vec ) {
	vec { DEFAULT_CAPACITY };
}

void ?{}( vector_int & vec, int reserve ) {
	vec.last = -1;
	vec.capacity = reserve;
	vec.data = (int *)malloc( sizeof( int ) * reserve );
}

void ?{}( vector_int & vec, vector_int other ) {
	vec.last = other.last;
	vec.capacity = other.capacity;
	vec.data = (int *)malloc( sizeof( int ) * other.capacity );
	for (int i = 0; i < vec.last; i++) {
		vec.data[i] = other.data[i];
	}
}

void ^?{}( vector_int & vec ) {
	free( vec.data );
}

void reserve( vector_int *vec, int reserve ) {
	if ( reserve > vec->capacity ) {
		vec->data = (int *)realloc( vec->data, sizeof( int ) * reserve );
		vec->capacity = reserve;
	}
}

void append( vector_int *vec, int element ) {
	vec->last++;
	if ( vec->last == vec->capacity ) {
		vec->capacity *= 2;
		vec->data = (int *)realloc( vec->data, sizeof( int ) * vec->capacity );
	}
	vec->data[ vec->last ] = element;
}

// implement bounded_array

int & ?[?]( vector_int * vec, int index ) {
	return vec->data[ index ];
}

int last( vector_int * vec ) {
	return vec->last;
}


// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa vector_int.c" //
// End: //
