//                               -*- Mode: C -*- 
// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// alloc.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Feb  3 07:56:22 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb  3 16:32:04 2016
// Update Count     : 38
// 

#include <fstream>
#include <stdlib>
extern "C" {
#include <stdlib.h>										// access C malloc, realloc
#include <stdio.h>
} // exten "C"

int * foo( int * p, int c ) { return p; }
int * bar( int * p, int c ) { return p; }
int * baz( int * p, int c ) { return p; }

int main( void ) {
    ofstream * sout = ofstream_stdout();

    size_t size = 10;
    int * p;
    struct S { int x; double y; } * s;

    p = malloc( sizeof(*p) );							// C malloc, type unsafe
	printf( "here1\n" );
    free( p );
    p = malloc();										// CFA malloc, type safe
	printf( "here2\n" );
    free( p );
    p = malloc( (char)'\0' );									// CFA malloc, type safe
	printf( "here3\n" );
    p = malloc( p, 1000 );								// CFA remalloc, type safe
	printf( "here4\n" );
    free( p );
    p = calloc( size, sizeof(*p) );						// C calloc, type unsafe
	printf( "here5\n" );
    free( p );
    p = calloc( size );									// CFA calloc, type safe
	printf( "here6\n" );
    free( p );
    p = calloc( size );									// CFA calloc, type safe
    p = realloc( p, 1000 );								// C realloc, type unsafe
    p = realloc( p, 1000, '\0' );						// CFA realloc, type unsafe
    p = memset( p );									// CFA memset, type unsafe
	printf( "here7\n" );
    free( p );
    p = memalign( 16 );
	printf( "here8\n" );
    free( p );
    posix_memalign( &p, 16 );
	printf( "here9\n" );
    free( p );
#if 0
    float * fp = malloc() + 1;
    fprintf( stderr, "%p %p\n", fp, fp - 1 );
    free( fp - 1 );
    p = realloc( st1, size, '\0' );						// C realloc, type unsafe

    double *y;
    x = memset( st1, '\0' );							// SHOULD FAIL!!

    int *p;
    p = foo( bar( baz( malloc(), 0 ), 0 ), 0 );
    free( p );

    struct St2 { int x; double y; };
    struct St2 * st2;

    y = malloc();
    st1 = malloc();
//    st1 = realloc( st2, 10, st1 );
  
    *y = 1.0;
    printf("%f\n", *y);

    st1->x = *x + 1;
    st1->y = *y *1.5;
    printf("{ %d, %f }\n", st1->x, st1->y);

    free( y );
  
    x = malloc( 10 );
    for ( int i = 0; i < 10; i += 1 ) {
	x[i] = i * 10;
    }
    for ( int j = 0; j < 10; j += 1 ) {
	printf( "x[%d] = %d\n", j, x[j] );
    }
    free( x );
#endif
    free( sout );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa alloc.c" //
// End: //
