// 
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// main.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Jun 28 22:57:26 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jun 29 09:02:37 2017
// Update Count     : 15
// 

#include <iostream>
#include <fstream>
#include <string>
using namespace std;
#include <unistd.h>										// close
#include "filter.h"

extern FILE * yyin;
extern int yylineno;
extern int yydebug;
extern int yyparse( void );

int main( int argc, char *argv[] ) {
	yyin = stdin;
	filter = Nocode;

	try {
		switch ( argc ) {
		  case 3:
			yyin = fopen( argv[ 2 ], "r" );
			if ( yyin == nullptr ) {
				throw ios_base::failure( "unknown printer option arguments" );
			} // if
			// FALL THROUGH
		  case 2: {
			  string arg( argv[1] );

			  if ( arg == "-identity" ) {
				  filter = Identity;
			  } else if ( arg == "-parse_tree" ) {
				  filter = Parse_Tree;
			  } else if ( arg == "-nocode" ) {
				  filter = Nocode;
			  } else if ( arg == "-latex" ) {
				  filter = LaTeX;
			  } else if ( arg == "-html" ) {
				  filter = HTML;
			  } else {
				  throw ios_base::failure( "unknown printer option arguments" );
			  } // if
			  break;
		  }
		  default:
			throw ios_base::failure( "wrong number of arguments" );
		} // switch
	} catch( ios_base::failure err ) {
		cerr << err.what() << endl;
		cerr << "Usage: [" << argv[0]
			 << "-identity |"
			 << "-parse_tree |"
			 << "-nocode |"
			 << "-latex |"
			 << "-html"
			 << "] [input-file]"
			 << endl;
		exit( EXIT_FAILURE );							// TERMINATE
	} // try

	//yydebug = 1;
	yyparse();

	if ( yyin != stdin ) fclose( yyin );				// close file, do not delete cin!
} // main

// Local Variables: //
// mode: c++ //
// tab-width: 4 //
// compile-command: "make install" //
// End: //
