#include <algorithm>

#include "Type.h"
#include "Declaration.h"
#include "utility.h"


FunctionType::FunctionType( const Type::Qualifiers &tq, bool isVarArgs ) : Type( tq ), isVarArgs( isVarArgs ) {
}

FunctionType::FunctionType( const FunctionType &other ) : Type( other ), isVarArgs( other.isVarArgs ) {
    cloneAll( other.returnVals, returnVals );
    cloneAll( other.parameters, parameters );
}

FunctionType::~FunctionType() {
    deleteAll( returnVals );
    deleteAll( parameters );
}

void FunctionType::print( std::ostream &os, int indent ) const {
    using std::string;
    using std::endl;

    Type::print( os, indent );
    os << "function" << endl;
    if ( ! parameters.empty() ) {
	os << string( indent + 2, ' ' ) << "with parameters" << endl;
	printAll( parameters, os, indent + 4 );
	if ( isVarArgs ) {
	    os << string( indent + 4, ' ' ) << "and a variable number of other arguments" << endl;
	}
    } else if ( isVarArgs ) {
	os << string( indent + 4, ' ' ) << "accepting unspecified arguments" << endl;
    }
    os << string( indent + 2, ' ' ) << "returning ";
    if ( returnVals.empty() ) {
	os << endl << string( indent + 4, ' ' ) << "nothing " << endl;
    } else {
	os << endl;
	printAll( returnVals, os, indent + 4 );
    }
}

