//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Declaration.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jul 13 17:58:38 2015
// Update Count     : 10
//

#include <string>
#include <map>
#include "Declaration.h"
#include "Expression.h"
#include "Initializer.h"
#include "Type.h"
#include "utility.h"

static UniqueId lastUniqueId = 0;
typedef std::map< UniqueId, Declaration* > IdMapType;
static IdMapType idMap;

Declaration::Declaration( const std::string &name, DeclarationNode::StorageClass sc, LinkageSpec::Type linkage )
		: name( name ), storageClass( sc ), linkage( linkage ), isInline( false ), isNoreturn( false ), uniqueId( 0 ) {
}

Declaration::Declaration( const Declaration &other )
	: name( other.name ), storageClass( other.storageClass ), linkage( other.linkage ), isInline( other.isInline ), isNoreturn( other.isNoreturn ), uniqueId( other.uniqueId ) {
}

Declaration::~Declaration() {
}

void Declaration::fixUniqueId() {
	uniqueId = ++lastUniqueId;
	idMap[ uniqueId ] = this;
}

Declaration *Declaration::declFromId( UniqueId id ) {
	IdMapType::const_iterator i = idMap.find( id );
	return i != idMap.end() ? i->second : 0;
}

void Declaration::dumpIds( std::ostream &os ) {
	for ( IdMapType::const_iterator i = idMap.begin(); i != idMap.end(); ++i ) {
		os << i->first << " -> ";
		i->second->printShort( os );
		os << std::endl;
	} // for
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
