//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CandidateFinder.hpp --
//
// Author           : Aaron B. Moss
// Created On       : Wed Jun 5 14:30:00 2019
// Last Modified By : Aaron B. Moss
// Last Modified On : Wed Jun 5 14:30:00 2019
// Update Count     : 1
//

#pragma once

#include "Candidate.hpp"
#include "ResolvMode.h"
#include "AST/Fwd.hpp"
#include "AST/Node.hpp"
#include "AST/SymbolTable.hpp"
#include "AST/TypeEnvironment.hpp"

namespace ResolvExpr {

/// Data to perform expression resolution
struct CandidateFinder {
	CandidateList candidates;          ///< List of candidate resolutions
	const ast::SymbolTable & symtab;   ///< Symbol table to lookup candidates
	const ast::TypeEnvironment & env;  ///< Substitutions performed in this resolution
	ast::ptr< ast::Type > targetType;  ///< Target type for resolution

	CandidateFinder( 
		const ast::SymbolTable & symtab, const ast::TypeEnvironment & env, 
		const ast::Type * tt = nullptr )
	: candidates(), symtab( symtab ), env( env ), targetType( tt ) {}

	/// Fill candidates with feasible resolutions for `expr`
	void find( const ast::Expr * expr, ResolvMode mode = {} );

	/// Runs new candidate finder on each element in xs, returning the list of finders
	std::vector< CandidateFinder > findSubExprs( const std::vector< ast::ptr< ast::Expr > > & xs );

	using value_type = CandidateList::value_type;
	using iterator = CandidateList::iterator;
	using const_iterator = CandidateList::const_iterator;

	iterator begin() { return candidates.begin(); }
	const_iterator begin() const { return candidates.begin(); }
	
	iterator end() { return candidates.end(); }
	const_iterator end() const { return candidates.end(); }
};

} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
