//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// virtual.c --
//
// Author           : Andrew Beach
// Created On       : Tus Jul 11 15:10:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Wed Jul 26 14:24:00 2017
// Update Count     : 1
//

#include "virtual.h"
#include "assert.h"

int __cfa__is_parent( struct __cfa__parent_vtable const * parent,
    	struct __cfa__parent_vtable const * child ) {
	assert( child );
	do {
		if ( parent == child )
			return 1;
		child = child->parent;
	} while ( child );
	return 0;
}

void * __cfa__virtual_cast( struct __cfa__parent_vtable const * parent,
    	struct __cfa__parent_vtable const * const * child ) {
	assert( child );
	return (__cfa__is_parent(parent, *child)) ? (void *)child : (void *)0;
}
