//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iterator.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:41:57 2015
// Update Count     : 3
//

#ifndef ITERATOR_H
#define ITERATOR_H

#include "iostream.h"

// An iterator can be used to traverse a data structure.
context iterator( type iterator_type, type elt_type ) {
	// point to the next element
//	iterator_type ?++( iterator_type * );
	iterator_type ++?( iterator_type * );
	iterator_type --?( iterator_type * );

	// can be tested for equality with other iterators
	int ?==?( iterator_type, iterator_type );
	int ?!=?( iterator_type, iterator_type );

	// dereference to get the pointed-at element
	lvalue elt_type *?( iterator_type );
};

context iterator_for ( type iterator_type, type collection_type, type elt_type | iterator( iterator_type, elt_type ) ) {
//	[ iterator_type begin, iterator_type end ] get_iterators( collection_type );
	iterator_type begin( collection_type );
	iterator_type end( collection_type );
};

forall( type iterator_type, type elt_type | iterator( iterator_type, elt_type ) )
void for_each( iterator_type begin, iterator_type end, void (*func)( elt_type ) );

// writes the range [begin, end) to the given stream
forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_all( iterator_type begin, iterator_type end, os_type *os );

forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_reverse( iterator_type begin, iterator_type end, os_type *os );

#endif // ITERATOR_H

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iterator.c" //
// End: //
