//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iterator.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jul  7 08:38:23 2017
// Update Count     : 28
//

#include "iterator"

forall( otype iterator_type, otype elt_type | iterator( iterator_type, elt_type ) )
void for_each( iterator_type begin, iterator_type end, void (* func)( elt_type ) ) {
	for ( iterator_type i = begin; i != end; ++i ) {
		func( *i );
	} // for
} // for_each

forall( otype iterator_type, otype elt_type | iterator( iterator_type, elt_type ) )
void for_each_reverse( iterator_type begin, iterator_type end, void (* func)( elt_type ) ) {
	for ( iterator_type i = end; i != begin; ) {
		--i;
		func( *i );
	} // for
} // for_each_reverse

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iterator.c" //
// End: //
