// Trying to create the new secret header for the exception handling mechanism.

// This will have to go in the public header later.
typedef int exception;



void __throw_terminate(exception except) __attribute__((noreturn));
void __rethrow_terminate(void) __attribute__((noreturn));
void __throw_resume(exception except);

void __try_terminate(void (*try_block)(),
	void (*catch_block)(int index, exception except),
	int (*match_block)(exception except));

struct __try_resume_node {
	struct __try_resume_node * next;
	_Bool (*try_to_handle)(exception except);
};

void __try_resume_cleanup(struct __try_resume_node * node);

struct __cleanup_hook {};



/* The following code is temperary. How exceptions interact with coroutines
 * and threads means that... well I'm going to get it working ignoring those
 * first, then get it working with concurrency.
 * Eventually there should be some global name that just gets you the right
 * data block.
 */
struct shared_stack_t {
	struct __try_resume_node * top_resume;
	struct __try_resume_node * current_resume;

	exception current_exception;
	int current_handler_index;
};

extern struct shared_stack_t shared_stack;
