#include "state.h"

// #include <stdlib.h>
//
// //general purpouse includes
// #include "tools.h"
//
// //platform abstraction includes
// #include "allocate-pool.h"
//
// //gc internal includes
// // #include "globals.h"
// #include "memory_pool.h"
// #include "memory_pool_iterator.h"
// #include "object_header.h"
//
// void swap(gc_state* state);
// void sweep_roots(worklist_t worklist);
// void clear(gc_state* state);
// void calc_usage(gc_state* state);
//
// #if DEBUG
// 	bool roots_match(gc_state* state);
// 	bool no_from_space_ref(gc_state* state);
// #endif

// void gc_state_ctor(gc_state* state)
// {
// 	state->from_code = 0;
// 	state->to_space = NULL;
// 	state->from_space = NULL;
// 	state->total_space = 0;
// 	state->used_space = 0;
// 	// state->pools_table();
//
// 	gc_allocate_pool(state);
//
// 	state->is_initialized = true;
// }

// bool state::is_in_heap(void* address) const
// {
// 	memory_pool* target_pool = gc_pool_of(address);
//
// 	auto first = pools_table.cbegin();
// 	auto last = pools_table.cend();
// 	auto result = std::find(first, last, target_pool);
// 	return result != last && (*result)->is_from_space();
// }

// bool state::is_in_to_space(void* address) const
// {
// 	const memory_pool* target_pool = pool_of(address);
//
// 	auto first = pools_table.cbegin();
// 	auto last = pools_table.cend();
// 	auto result = std::find(first, last, target_pool);
// 	return result != last && !(*result)->is_from_space();
// }
//
// gc_object_header* gc_get_object_for_ref(gc_state* state, void* member)
// {
// 	intptr_t target = ((intptr_t)member);
// 	if(!gc_is_in_heap(state, member)) return NULL;
//
// 	gc_memory_pool* pool = gc_pool_of(member);
// 	gc_pool_object_iterator it = gc_pool_iterator_for(pool, member);
// 	gc_pool_object_iterator end = gc_pool_end(pool);
//
// 	while(it != end)
// 	{
// 		gc_object_header* object = *it;
// 		{
// 			intptr_t start = ((intptr_t)object);
// 			intptr_t end = ((intptr_t)start + object->size);
// 			if(start < target && end > target)
// 			{
// 				return object;
// 			}
// 		}
// 		++it;
// 	}
//
// 	checkf(false, "is_in_heap() and iterator_for() return inconsistent data");
// 	abort();
// 	return NULL;
// }
//
// void* state::try_allocate(size_t size)
// {
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		if(pool->size_left() > size)
// 		{
// 			return pool->allocate(size, true);
// 		}
// 		pool = pool->next();
// 	}
//
// 	return nullptr;
// }
//
// void state::allocate_pool()
// {
// 	memory_pool* old_from_space = from_space;
//       memory_pool* old_to_space = to_space;
//
//       from_space = reinterpret_cast<memory_pool*>(pal_allocPool(POOL_SIZE_BYTES, 1));
//       to_space = reinterpret_cast<memory_pool*>(pal_allocPool(POOL_SIZE_BYTES, 1));
//
//       new (from_space) memory_pool(POOL_SIZE_BYTES, old_from_space, to_space, from_code);
//       new (to_space) memory_pool(POOL_SIZE_BYTES, old_to_space, from_space, (~from_code) & 0x01);
//
// 	total_space += from_space->size();
//
// 	pools_table.push_back(from_space);
// 	pools_table.push_back(to_space);
// }
//
// void state::collect()
// {
// 	DEBUG("collecting");
// 	DEBUG("previous usage " << used_space << " / " << total_space);
//
// 	std::vector<void**> worklist;
// 	sweep_roots(worklist);
//
// 	while(!worklist.empty())
// 	{
// 		void** ref = worklist.back();
// 		worklist.pop_back();
// 		process_reference(ref, worklist);
// 	}
//
// 	check(roots_match());
// 	check(no_from_space_ref());
//
// 	swap();
//
// 	calc_usage();
//
// 	if(needs_collect()) allocate_pool();
//
// 	DEBUG("done");
// }
//
// void state::swap()
// {
// 	std::swap(from_space, to_space);
//
// 	memory_pool* pool = to_space;
// 	while(pool)
// 	{
// 		pool->reset();
// 		pool = pool->next();
// 	}
//
// 	from_code = (~from_code) & 0x01;
//
// 	#if _DEBUG
// 		{
// 			memory_pool* pool = from_space;
// 			while(pool)
// 			{
// 				check(pool->is_from_space());
// 				pool = pool->next();
// 			}
//
// 			pool = to_space;
// 			while(pool)
// 			{
// 				check(!pool->is_from_space());
// 				pool = pool->next();
// 			}
// 		}
// 	#endif
// }
//
// void state::sweep_roots(std::vector<void**>& worklist)
// {
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		for(object_header* object : *pool)
// 		{
// 			if(!object->root_chain) continue;
//
// 			copy_object(object);
//
// 			scan_object(object->forward, worklist);
// 		}
//
// 		pool = pool->next();
// 	}
// }
//
// void state::clear()
// {
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		pool->reset();
// 		pool = pool->next();
// 	}
//
// 	pool = to_space;
// 	while(pool)
// 	{
// 		pool->reset();
// 		pool = pool->next();
// 	}
// }
//
// void state::calc_usage()
// {
// 	total_space = 0;
// 	used_space = 0;
//
// 	memory_pool* pool = from_space;
// 	while(pool)
// 	{
// 		size_t size = pool->size();
// 		size_t used = size - pool->size_left();
// 		check(used <= size);
// 		total_space += size;
// 		used_space += used;
//
// 		pool = pool->next();
// 	}
// }
//
// #if _DEBUG
// 	bool state::roots_match()
// 	{
// 		memory_pool* pool = to_space;
// 		while(pool)
// 		{
// 			size_t size = 0;
// 			for(object_header* object : *pool)
// 			{
// 				size += object->size;
//
// 				gcpointer_base* ptr = object->root_chain;
// 				while(ptr)
// 				{
// 					check(get_object_ptr(ptr->m_ptr) == object);
// 					ptr = ptr->m_next;
// 				}
// 			}
//
// 			check(size + pool->size_left() == pool->size());
//
// 			pool = pool->next();
// 		}
//
// 		return true;
// 	}
//
// 	bool state::no_from_space_ref()
// 	{
// 		memory_pool* pool = to_space;
// 		while(pool)
// 		{
// 			void** potential_ref = (void**)pool->m_start;
// 			while(potential_ref < (void**)pool->m_free)
// 			{
// 				check(!is_in_heap(*potential_ref));
// 				potential_ref++;
// 			}
//
// 			pool = pool->next();
// 		}
//
// 		return true;
// 	}
// #endif
