//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Tables.h --
//
// Author           : Andrew Beach
// Created On       : Mon Aug 31 11:07:00 2020
// Last Modified By : Andrew Beach
// Last Modified On : Tue Sep  1 14:29:00 2020
// Update Count     : 0
//

#include <list>  // for list

class Declaration;
class StructDecl;
class Expression;

namespace Virtual {

std::string vtableTypeName( std::string const & type_name );
std::string instanceName( std::string const & vtable_name );
std::string vtableInstanceName( std::string const & type_name );
bool isVTableInstanceName( std::string const & name );

/// Converts exceptions into regular structures.
//void ( std::list< Declaration * > & translationUnit );

ObjectDecl * makeVtableForward( StructInstType * );
ObjectDecl * makeVtableForward( StructDecl *, std::list< Expression * > && );
/* Create a forward definition of a vtable of the given type.
 *
 * Instead of the virtual table type you may provide the declaration and all
 * the forall parameters.
 */

ObjectDecl * makeVtableInstance( StructInstType *, Type *, Initializer * );
ObjectDecl * makeVtableInstance(
	StructDecl *, std::list< Expression * > &&, Type *, Initializer * );
/* Create an initialized definition of a vtable.
 *
 * The parameters are the virtual table type (or the base declaration and the
 * forall parameters), the object type and optionally an initializer.
 *
 * Instead of the virtual table type you may provide the declaration and all
 * the forall parameters.
 */

}
