//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.c --
//
// Author           : Peter A. Buhr
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Feb 23 22:49:37 2017
// Update Count     : 309
//

#include "iostream"

extern "C" {
#include <stdio.h>
#include <string.h>										// strlen
#include <float.h>										// DBL_DIG, LDBL_DIG
#include <complex.h>									// creal, cimag
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, char c ) {
	prtfmt( os, "%c", c );
	sepOff( os );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, signed char c ) {
	prtfmt( os, "%hhd", c );
	sepOff( os );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned char c ) {
	prtfmt( os, "%hhu", c );
	sepOff( os );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, short int si ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%hd", si );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned short int usi ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%hu", usi );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, int i ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%d", i );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned int ui ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%u", ui );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long int li ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%ld", li );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned long int uli ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%lu", uli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long long int lli ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%lld", lli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned long long int ulli ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%llu", ulli );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, float f ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%g", f );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, double d ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%.*lg", DBL_DIG, d );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long double ld ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%.*Lg", LDBL_DIG, ld );
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, float _Complex fc ) {
	os | crealf( fc );
	_Bool temp = sepDisable( os );						// disable separators within complex value
	if ( cimagf( fc ) >= 0 ) os | '+';					// negative value prints '-'
	os | cimagf( fc ) | 'i';
	sepReset( os, temp );								// reset separator
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, double _Complex dc ) {
	os | creal( dc );
	_Bool temp = sepDisable( os );						// disable separators within complex value
	if ( cimag( dc ) >= 0 ) os | '+';					// negative value prints '-'
	os | cimag( dc ) | 'i';
	sepReset( os, temp );								// reset separator
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long double _Complex ldc ) {
	os | creall( ldc );
	_Bool temp = sepDisable( os );						// disable separators within complex value
	if ( cimagl( ldc ) >= 0 ) os | '+';					// negative value prints '-'
	os | cimagl( ldc ) | 'i';
	sepReset( os, temp );								// reset separator
	return os;
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, const char *cp ) {
	enum { Open = 1, Close, OpenClose };
	static const unsigned char mask[256] = {
		// opening delimiters
		['('] : Open, ['['] : Open, ['{'] : Open,
		['$'] : Open, [(unsigned char)''] : Open, [(unsigned char)''] : Open,
		[(unsigned char)''] : Open, [(unsigned char)''] : Open, [(unsigned char)''] : Open,
		// closing delimiters
		[','] : Close, ['.'] : Close, [':'] : Close, [';'] : Close, ['!'] : Close, ['?'] : Close,
		[')'] : Close, [']'] : Close, ['}'] : Close,
		['%'] : Close, [(unsigned char)''] : Close, [(unsigned char)''] : Close,
		// opening-closing delimiters
		['\''] : OpenClose, ['`'] : OpenClose, ['"'] : OpenClose,
		[' '] : OpenClose, ['\f'] : OpenClose, ['\n'] : OpenClose, ['\r'] : OpenClose, ['\t'] : OpenClose, ['\v'] : OpenClose, // isspace
	}; // mask

  if ( cp[0] == '\0' ) { sepOff( os ); return os; }		// null string => no separator

	// first character IS NOT spacing or closing punctuation => add left separator
	unsigned char ch = cp[0];							// must make unsigned
	if ( sepPrt( os ) && mask[ ch ] != Close && mask[ ch ] != OpenClose ) {
		prtfmt( os, "%s", sepGet( os ) );
	} // if

	// if string starts line, must reset to determine open state because separator is off
	sepReset( os );										// reset separator

	// last character IS spacing or opening punctuation => turn off separator for next item
	unsigned int len = strlen( cp ), posn = len - 1;
	ch = cp[posn];										// must make unsigned
	if ( sepPrt( os ) && mask[ ch ] != Open && mask[ ch ] != OpenClose ) {
		sepOn( os );
	} else {
		sepOff( os );
	} // if
	return write( os, cp, len );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, const void *p ) {
	if ( sepPrt( os ) ) prtfmt( os, "%s", sepGet( os ) );
	prtfmt( os, "%p", p );
	return os;
} // ?|?


forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype * os, ostype * (* manip)( ostype * ) ) {
	return manip( os );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * endl( ostype * os ) {
	os | '\n';
	flush( os );
	sepOff( os );
	return os;
} // endl

forall( dtype ostype | ostream( ostype ) )
ostype * sepOn( ostype * os ) {
	sepOn( os );
	return os;
} // sepOn

forall( dtype ostype | ostream( ostype ) )
ostype * sepOff( ostype * os ) {
	sepOff( os );
	return os;
} // sepOff

forall( dtype ostype | ostream( ostype ) )
ostype * sepEnable( ostype * os ) {
	sepEnable( os );
	return os;
} // sepEnable

forall( dtype ostype | ostream( ostype ) )
ostype * sepDisable( ostype * os ) {
	sepDisable( os );
	return os;
} // sepDisable

//---------------------------------------

forall( otype elttype | writeable( elttype ), otype iteratortype | iterator( iteratortype, elttype ), dtype ostype | ostream( ostype ) )
void write( iteratortype begin, iteratortype end, ostype *os ) {
	void print( elttype i ) { os | i; }
	for_each( begin, end, print );
} // ?|?

forall( otype elttype | writeable( elttype ), otype iteratortype | iterator( iteratortype, elttype ), dtype ostype | ostream( ostype ) )
void write_reverse( iteratortype begin, iteratortype end, ostype *os ) {
	void print( elttype i ) { os | i; }
	for_each_reverse( begin, end, print );
} // ?|?

//---------------------------------------

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, char * c ) {
	scanfmt( is, "%c", c );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, short int * si ) {
	scanfmt( is, "%hd", si );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned short int * usi ) {
	scanfmt( is, "%hu", usi );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, int * i ) {
	scanfmt( is, "%d", i );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned int * ui ) {
	scanfmt( is, "%u", ui );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long int * li ) {
	scanfmt( is, "%ld", li );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned long int * ulli ) {
	scanfmt( is, "%lu", ulli );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long long int * lli ) {
	scanfmt( is, "%lld", lli );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, unsigned long long int * ulli ) {
	scanfmt( is, "%llu", ulli );
	return is;
} // ?|?


forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, float * f ) {
	scanfmt( is, "%f", f );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, double * d ) {
	scanfmt( is, "%lf", d );
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long double * ld ) {
	scanfmt( is, "%Lf", ld );
	return is;
} // ?|?


forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, float _Complex * fc ) {
	float re, im;
	scanfmt( is, "%g%gi", &re, &im );
	*fc = re + im * _Complex_I;
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, double _Complex * dc ) {
	double re, im;
	scanfmt( is, "%lf%lfi", &re, &im );
	*dc = re + im * _Complex_I;
	return is;
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, long double _Complex * ldc ) {
	long double re, im;
	scanfmt( is, "%Lf%Lfi", &re, &im );
	*ldc = re + im * _Complex_I;
	return is;
} // ?|?

_Istream_cstrUC cstr( char * str ) { return (_Istream_cstrUC){ str }; }
forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, _Istream_cstrUC cstr ) {
	scanfmt( is, "%s", cstr.s );
	return is;
} // cstr

_Istream_cstrC cstr( char * str, int size ) { return (_Istream_cstrC){ str, size }; }
forall( dtype istype | istream( istype ) )
istype * ?|?( istype * is, _Istream_cstrC cstr ) {
	char buf[16];
	sprintf( buf, "%%%ds", cstr.size );
	scanfmt( is, buf, cstr.s );
	return is;
} // cstr

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
