//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypeDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Mar 16 07:49:58 2017
// Update Count     : 5
//

#include "Declaration.h"
#include "Type.h"
#include "Common/utility.h"

TypeDecl::TypeDecl( const std::string &name, Type::StorageClasses scs, Type *type, Kind kind ) : Parent( name, scs, type ), kind( kind ), sized( kind == Any || kind == Ttype ) {
}

TypeDecl::TypeDecl( const TypeDecl &other ) : Parent( other ), kind( other.kind ), sized( other.sized ) {
}

std::string TypeDecl::typeString() const {
	static const std::string kindNames[] = { "type", "incomplete type", "function type", "tuple type" };
	return (kind != Any && isComplete() ? "sized " : "") + kindNames[ kind ];
}

std::string TypeDecl::genTypeString() const {
	static const std::string kindNames[] = { "otype", "dtype", "ftype", "ttype" };
	return kindNames[ kind ];
}

std::ostream & operator<<( std::ostream & os, const TypeDecl::Data & data ) {
  return os << data.kind << ", " << data.isComplete;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
