//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Generate.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jun  4 14:04:25 2015
// Update Count     : 5
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <list>

#include "Generate.h"
#include "SynTree/Declaration.h"
#include "CodeGenerator.h"
#include "GenType.h"
#include "SynTree/SynTree.h"
#include "SynTree/Type.h"
#include "SynTree/BaseSyntaxNode.h"
// #include "Tuples/Tuples.h"

using namespace std;

namespace CodeGen {
	void generate( std::list< Declaration* > translationUnit, std::ostream &os, bool doIntrinsics, bool pretty, bool generateC ) {
		CodeGen::CodeGenerator cgv( os, pretty, generateC );
		for ( auto & dcl : translationUnit ) {
			if ( LinkageSpec::isGeneratable( dcl->get_linkage() ) && (doIntrinsics || ! LinkageSpec::isBuiltin( dcl->get_linkage() ) ) ) {
				dcl->accept(cgv);
				if ( doSemicolon( dcl ) ) {
					os << ";";
				} // if
				os << std::endl;
			} // if
		} // for
	}

	void generate( BaseSyntaxNode * node, std::ostream & os ) {
		if ( Type * type = dynamic_cast< Type * >( node ) ) {
			os << CodeGen::genPrettyType( type, "" );
		} else {
			CodeGen::CodeGenerator cgv( os, true, false );
			node->accept( cgv );
		}
		os << std::endl;
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
