set terminal pslatex size 4, 2.0 color solid 9;
#set terminal postscript portrait enhanced size 7.5, 10. color solid 9.5;
#set terminal wxt size 950,1250

DIR=GRAPH
SCALE=1000000

set macros
set output GRAPH.".larson.tex"
#set pointsize 2.0
set grid linetype 0
set xtics (4,8,16,32)
set format y "%4g"
set logscale x
#set logscale y
top=.9
set key at screen 1.3, screen top - .01
set ylabel sprintf( "Throughput, sec., $\\times$ %g", SCALE ) offset 2,0

array titles[2];
titles[1] = "30 16 4096 8096 100 4141"
titles[2] = "5 8 1000 5000 100 4141"

set multiplot layout 1,2 rowsfirst margins 0.2,top,0.03,top spacing 0.24,0.08
do for [x = 0:1] {
	set title "args ". titles[x+1]
	plot DIR."/larsondata" \
		   i x*7 using 1:($2/SCALE) title columnheader(1) lt rgb "blue"	pt  2  ps 2 lw 1, \
		'' i x*7+1 using 1:($2/SCALE) title columnheader(1) lt rgb "dark-green"	pt  3  ps 2 lw 1, \
		'' i x*7+2 using 1:($2/SCALE) title columnheader(1) lt rgb "coral"	pt  14  ps 2 lw 4, \
		'' i x*7+3  using 1:($2/SCALE) title columnheader(1) lt rgb "black"	pt  16  ps 2 lw 2, \
		'' i x*7+4 using 1:($2/SCALE) title columnheader(1) lt rgb "red"	pt  8  ps 2 lw 2, \
		'' i x*7+5 using 1:($2/SCALE) title columnheader(1) lt rgb "dark-violet" pt  10  ps 2 lw 1, \
		'' i x*7+6 using 1:($2/SCALE) title columnheader(1) lt rgb "brown"	pt  4  ps 2 lw 1
} # for
