//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// SemanticError.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Aug 29 18:17:35 2017
// Update Count     : 3
//

#include <cstdio>										// for fileno, stderr
#include <unistd.h>										// for isatty
#include <iostream>										// for basic_ostream, operator<<, ostream
#include <list>											// for list, _List_iterator
#include <string>										// for string, operator<<, operator+, to_string

#include "Common/utility.h"								// for to_string, CodeLocation (ptr only)
#include "SemanticError.h"

SemanticError::SemanticError( CodeLocation location, std::string error ) {
	append( location, error );
}

void SemanticError::append( SemanticError &other ) {
	errors.splice( errors.end(), other.errors );
}

void SemanticError::append( CodeLocation location, const std::string & msg ) {
	errors.emplace_back( location, msg );
}

bool SemanticError::isEmpty() const {
	return errors.empty();
}

void SemanticError::print() {
	using std::to_string;
	for( auto err : errors ) {
		std::cerr << bold() << err.location << error_str() << reset_font() << err.description << std::endl;
	}
}

SemanticWarning::SemanticWarning( CodeLocation location, std::string msg ) {
	std::cerr << bold() << location << warning_str() << reset_font() << msg << std::endl;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
