#include <cassert>
#include <clib/cfathread.h>

typedef cfathread_t thread_t;
static_assert(sizeof(thread_t) == sizeof(void*), "thread_t musst be of same size as void*");

#if !defined(__cplusplus)
#error no __cplusplus define!
#endif

extern "C" {
	//--------------------
	// Basic thread support
	thread_t thrdlib_create( void (*the_main)( thread_t ) ) {
		return cfathread_create( the_main );
	}

	void thrdlib_join( thread_t handle ) {
		cfathread_join( handle );
	}

	void thrdlib_park( thread_t ) {
		cfathread_park();
	}

	void thrdlib_unpark( thread_t handle ) {
		cfathread_unpark( handle );
	}

	void thrdlib_yield( void ) {
		cfathread_yield();
	}

	//--------------------
	// Basic kernel features
	void thrdlib_init( int procs ) {
		cfathread_setproccnt(procs);
	}

	void thrdlib_clean( void ) {
		cfathread_setproccnt(1);
	}
}