#include "Validate/FixEnumeratedArray.hpp"

#include "AST/Pass.hpp"                  // WithCodeLocation
#include "Validate/NoIdSymbolTable.hpp"  // NoIdSymbolTable

namespace Validate {
namespace {
struct FixEnumeratedArray : public NoIdSymbolTable,
                            
                            public ast::WithCodeLocation,
                            public ast::WithShortCircuiting,
                            public ast::WithDeclsToAdd<> {

    ast::ObjectDecl const * previsit( ast::ObjectDecl const * decl ) {
        if (decl->isTypeFixed) return decl;
        if (auto arrayDecl = decl->type.as<ast::ArrayType>()) {
            auto declaredType = arrayDecl->declaredType;
            if (!declaredType) return decl;
            auto initializers = decl->init.strict_as<ast::ListInit>();
            if (auto declaredEnum = declaredType.as<ast::EnumDecl>()) {
                auto forwardingEnum = mutate(declaredEnum);
                for (auto designation : initializers->designations) {
                    std::deque<ast::ptr<ast::Expr>> designatorList =
                        designation->designators;
                    if (designatorList.size() != 1) {
                        SemanticError(forwardingEnum,
                                      "Multiple Initialization in enumerated "
                                      "array is not supported.");
                    }
                    ast::ptr<ast::Expr> designator = designatorList.at(0);

                    ast::ptr<ast::NameExpr> designatorAsName =
                        designator.as<ast::NameExpr>();
                    if (!designatorAsName) {
                        SemanticError(
                            forwardingEnum,
                            "Enumerated Array with inlined enum declaration "
                            "can only use string as its initializer");
                    }
                    ast::ObjectDecl* memberDecl = new ast::ObjectDecl(
                        declaredEnum->location, designatorAsName->name,
                        new ast::EnumInstType(declaredEnum, ast::CV::Const));
                    forwardingEnum->members.push_back(memberDecl);
                }
                // addEnum(forwardingEnum);
                declsToAddBefore.push_back( forwardingEnum );
            }
        }
        return decl;
    }

};  // namespace

}  // namespace
void fixEnumeratedArray(ast::TranslationUnit& translationUnit) {
    ast::Pass<FixEnumeratedArray>::run(translationUnit);
}

};  // namespace Validate
