//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.cc -- 
// 
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:22:09 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Aug 19 15:53:05 2015
// Update Count     : 5
// 

#include <string>
#include <cassert>

#include "LinkageSpec.h"
#include "Common/SemanticError.h"

LinkageSpec::Type LinkageSpec::fromString( const std::string &stringSpec ) {
	if ( stringSpec == "\"Cforall\"" ) {
		return Cforall;
	} else if ( stringSpec == "\"C\"" ) {
		return C;
	} else {
		throw SemanticError( "Invalid linkage specifier " + stringSpec );
	}
}

std::string LinkageSpec::toString( LinkageSpec::Type linkage ) {
	switch ( linkage ) {
	  case Intrinsic:
		return "intrinsic";
	  case Cforall:
		return "Cforall";
	  case C:
		return "C";
	  case AutoGen:
		return "automatically generated";
	  case Compiler:
		return "compiler built-in";
	}
	assert( false );
	return "";
}

bool LinkageSpec::isDecoratable( Type t ) {
	switch ( t ) {
	  case Intrinsic:
	  case Cforall:
	  case AutoGen:
		return true;
	  case C:
	  case Compiler:
		return false;
	}
	assert( false );
	return false;
}

bool LinkageSpec::isGeneratable( Type t ) {
	switch ( t ) {
	  case Intrinsic:
	  case Cforall:
	  case AutoGen:
	  case C:
		return true;
	  case Compiler:
		return false;
	}
	assert( false );
	return false;
}

bool LinkageSpec::isOverloadable( Type t ) {
	return isDecoratable( t );
}


bool LinkageSpec::isOverridable( Type t ) {
	switch ( t ) {
	  case Intrinsic:
	  case AutoGen:
		return true;
	  case Cforall:
	  case C:
	  case Compiler:
		return false;
	}
	assert( false );
	return false;
}

bool LinkageSpec::isBuiltin( Type t ) {
	switch ( t ) {
	  case Cforall:
	  case AutoGen:
	  case C:
		return false;
	  case Intrinsic:
	  case Compiler:
		return true;
	}
	assert( false );
	return false;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
