//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// VarExprReplacer.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jan 13 16:29:30 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 13 11:27:52 2016
// Update Count     : 5
//

#include <iostream>       // for operator<<, basic_ostream, ostream, basic_o...

#include "Declaration.h"  // for operator<<, DeclarationWithType
#include "Expression.h"   // for VariableExpr
#include "VarExprReplacer.h"

VarExprReplacer::VarExprReplacer( const DeclMap & declMap, bool debug ) : declMap( declMap ), debug( debug ) {}

VarExprReplacer::~VarExprReplacer() {
	for ( auto p : declMap ) {
		delete p.second;
	}
}

// replace variable with new node from decl map
Expression * VarExprReplacer::mutate( VariableExpr * varExpr ) {
	// xxx - assertions and parameters aren't accounted for in this... (i.e. they aren't inserted into the map when it's made, only DeclStmts are)
	if ( declMap.count( varExpr->var ) ) {
		Expression * expr = declMap.at( varExpr->var );
		if ( debug ) {
			std::cerr << "replacing variable reference: " << (void*)varExpr->var << " " << varExpr->var << " with " << (void*)expr << " " << expr << std::endl;
		}
		delete varExpr;
		return expr->clone();
	}
	return varExpr;
}
