//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TupleType.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb  1 17:10:58 2017
// Update Count     : 3
//

#include "Type.h"
#include "Common/utility.h"

TupleType::TupleType( const Type::Qualifiers &tq, const std::list< Type * > & types, const std::list< Attribute * > & attributes ) : Type( tq, attributes ), types( types ) {
}

TupleType::TupleType( const TupleType& other ) : Type( other ) {
	cloneAll( other.types, types );
}

TupleType::~TupleType() {
	deleteAll( types );
}

void TupleType::print( std::ostream &os, int indent ) const {
	Type::print( os, indent );
	os << "tuple of types" << std::endl;
	printAll( types, os, indent+2 );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
