// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// gmp.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Apr 19 08:55:51 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 24 09:33:26 2017
// Update Count     : 543
// 

#include <gmp>

int main( void ) {
	sout | "constructors" | endl;
	short int si = 3;
	Int x = { "50000000000000000000" }, y = { si }, z = x + y;
	sout | x | y | z | endl;
	sout | "x:" | x | "y:" | y | "z:" | z | endl;

	sout | "conversions" | endl;
	y = 'a';
	sout | "y:" | y | endl;
	y = "12345678901234567890123456789";
	sout | "y:" | y | endl;
	y = si;
	sout | "y:" | y | endl;
	y = -3;
	sout | "y:" | y | endl;
	y += 7;
	sout | "y:" | y | endl;
	y -= 1;
	sout | "y:" | y | endl;
	int b;
	b = y;
	si = y;
	sout | "y:" | y | "b:" | b | "si:" | si | endl;

	sout | "comparison" | endl;
	sout | x == x | endl;
	sout | x != x | endl;
	sout | x < x | endl;
	sout | x <= x | endl;
	sout | x > x | endl;
	sout | x >= x | endl;

	sout | "arithmetic" | endl;
	z = x + y + z;
	sout | "z:" | z | endl;
	z = z = x;
	sout | "z:" | z | endl;
	z = x - y - z;
	sout | "z:" | z | endl;
	z = x * y * z;
	sout | "z:" | z | endl;
	z = x * 3;
	sout | "z:" | z | endl;
	z = 3 * x;
	sout | "z:" | z | endl;
	z = x / 3;
	sout | "z:" | z | endl;
	sout | div( x, 3 ) | x / 3 | "," | x % 3 | endl;
	[ x, y ] = div( x, 3 );
	sout | "x:" | x | "y:" | y | endl;

	sout | endl;

	sin | x | y | z;
	sout | x | y | z | endl;

	sout | endl;

	sout | "Fibonacci Numbers" | endl;
	Int fn, fn1, fn2;
	fn = (Int){0}; fn1 = fn;							// 1st case
	sout | (int)0 | fn | endl;
	fn = 1; fn2 = fn1; fn1 = fn;						// 2nd case
	sout | 1 | fn | endl;
	for ( unsigned int i = 2; i <= 200; i += 1 ) {
		fn = fn1 + fn2; fn2 = fn1; fn1 = fn;			// general case
		sout | i | fn | endl;
	} // for

	sout | endl;

	sout | "Factorial Numbers" | endl;
	Int fact;
	fact = 1;											// 1st case
	sout | (int)0 | fact | endl;
	for ( unsigned int i = 1; i <= 40; i += 1 ) {
		fact *= i;										// general case
		sout | i | fact | endl;
	} // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa gmp.c -lgmp" //
// End: //
