//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// alarm.h --
//
// Author           : Thierry Delisle
// Created On       : Fri Jun 2 11:31:25 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Mar 26 16:25:41 2018
// Update Count     : 11
//

#pragma once

#include <stdbool.h>
#include <stdint.h>

#include <assert.h>

#include "time"

struct thread_desc;
struct processor;

//=============================================================================================
// Clock logic
//=============================================================================================

Time __kernel_get_time();
void __kernel_set_timer( Duration alarm );

//=============================================================================================
// Alarm logic
//=============================================================================================

struct alarm_node_t {
	Time alarm;				// time when alarm goes off
	Duration period;			// if > 0 => period of alarm
	alarm_node_t * next;		// intrusive link list field

	union {
		thread_desc * thrd;	// thrd who created event
		processor * proc;		// proc who created event
	};

	bool set		:1;		// whether or not the alarm has be registered
	bool kernel_alarm	:1;		// true if this is not a user defined alarm
};

typedef alarm_node_t ** __alarm_it_t;

void ?{}( alarm_node_t & this, thread_desc * thrd, Time alarm, Duration period );
void ?{}( alarm_node_t & this, processor   * proc, Time alarm, Duration period );
void ^?{}( alarm_node_t & this );

struct alarm_list_t {
	alarm_node_t * head;
	__alarm_it_t tail;
};

static inline void ?{}( alarm_list_t & this ) with( this ) {
	head = 0;
	tail = &head;
}

void insert( alarm_list_t * this, alarm_node_t * n );
alarm_node_t * pop( alarm_list_t * this );

void register_self  ( alarm_node_t * this );
void unregister_self( alarm_node_t * this );

// Local Variables: //
// mode: c //
// tab-width: 6 //
// End: //
