//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CaseRangeMutator.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : 
// Last Modified On : Sun Jul 31 12:16:28 2016
// Update Count     : 32
//

#include <list>
#include <cassert>
#include <cstdlib>
#include <iterator>

#include "Common/utility.h"

#include "SynTree/Statement.h"
#include "SynTree/Expression.h"
#include "SynTree/Constant.h"
#include "SynTree/Type.h"
#include "CaseRangeMutator.h"

namespace ControlStruct {
	Statement *CaseRangeMutator::mutate( SwitchStmt *switchStmt ) {
		std::list< Statement * > &cases = switchStmt->get_branches();

		// a `for' would be more natural... all this contortions are because `replace' invalidates the iterator
		std::list< Statement * >::iterator i = cases.begin();
		while ( i != cases.end() ) {
			(*i)->acceptMutator( *this );

			if ( ! newCaseLabels.empty() ) {
				std::cout << "FRED" << std::endl;
				std::list< Statement * > newCases;

				// transform( newCaseLabels.begin(), newCaseLabels.end(), bnd1st( ptr_fun( ctor< CaseStmt, Label, Expression * > ) ) );

				for ( std::list< Expression * >::iterator j = newCaseLabels.begin(); j != newCaseLabels.end(); j++ ) {
					std::list< Label > emptyLabels;
					std::list< Statement * > emptyStmts;
					newCases.push_back( new CaseStmt( emptyLabels, *j, emptyStmts ) );
				} // for

				if ( CaseStmt *currentCase = dynamic_cast< CaseStmt * >( *i ) )
					if ( ! currentCase->get_statements().empty() ) {
						CaseStmt *lastCase = dynamic_cast< CaseStmt * >( newCases.back() );
						if ( lastCase == 0 ) { throw ( 0 ); /* FIXME */ } // something is very wrong, as I just made these, and they were all cases
						// transfer the statement block ( if any ) to the new list:
						lastCase->set_statements( currentCase->get_statements() );
					} // if
				std::list< Statement * >::iterator j = i;
				advance( j, 1 );
				replace( cases, i, newCases );
				i = j;
				newCaseLabels.clear();
			} else
				i++;
		} // while

		return switchStmt;
	} // CaseRangeMutator::mutate

	Statement *CaseRangeMutator::mutate( CaseStmt *caseStmt ) {
		// case list, e.g., case 1, 3, 5:
		if ( TupleExpr *tcond = dynamic_cast< TupleExpr * >( caseStmt->get_condition() ) ) {
			assert( ! tcond->get_exprs().empty() );
			for ( std::list< Expression * >::iterator i = tcond->get_exprs().begin(); i != tcond->get_exprs().end(); i++ ) {
				newCaseLabels.push_back( *i );			// do I need to clone them?
			} // for
		} // if

		std::list< Statement * > &stmts = caseStmt->get_statements();
		mutateAll( stmts, *this );

		return caseStmt;
	} // CaseRangeMutator::mutate
} // namespace ControlStruct

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
