#include <sys/queue.h>
#include <stdbool.h>

#define HEADNAME_(S)                             S ## Head

#define BFX_INTRUSION(S)                         TAILQ_ENTRY(S) xx;
#define BFX_EXTRUSION_DECL(S)
#define BFX_EXTRUSION_FOLLOWUP(S)                TAILQ_HEAD(HEADNAME_(S), S);
#define BFX_LIST_HEAD_T(S)                       struct HEADNAME_(S)
#define BFX_LISTED_ELEM_T(S)                     S*

#define BFX_INSERT_FIRST(S, lst, item)           ({TAILQ_INSERT_HEAD(&lst, &item, xx); &item;})
#define BFX_INSERT_LAST(S, lst, item)            ({TAILQ_INSERT_TAIL(&lst, &item, xx); &item;})
#define BFX_INSERT_BEFORE(S, lst, item, refIter) ({TAILQ_INSERT_BEFORE(refIter, &item, xx); &item;})
#define BFX_INSERT_AFTER(S, lst, item, refIter)  ({TAILQ_INSERT_AFTER(&lst, refIter, &item, xx); &item;})
#define BFX_REMOVE_FIRST(S, lst)                 ({ S * first=TAILQ_FIRST( &lst );               TAILQ_REMOVE( &lst, first, xx ); })   // about two steps: see tailq-bug.c
#define BFX_REMOVE_LAST(S, lst)                  ({ S * last =TAILQ_LAST ( &lst, HEADNAME_(S) ); TAILQ_REMOVE( &lst, last , xx ); })
#define BFX_REMOVE_HERE(S, lst, refIter)         TAILQ_REMOVE( &lst, refIter, xx )
#define BFX_INIT(S, lst)                         TAILQ_INIT(&lst);

#define BFX_GET_FIRST(S, lst)                    TAILQ_FIRST(&lst)
#define BFX_GET_AFTER(S, lst, iter)              TAILQ_NEXT(iter, xx)
#define BFX_GET_BEFORE(S, lst, iter)             TAILQ_PREV(iter, HEADNAME_(S), xx)
#define BFX_IS_VALID_POS(S, lst, iter)           ((iter)!=NULL)
#define BFX_DEREF_POS(S, lst, iter)              (iter)
