//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:24:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Aug 20 19:22:23 2016
// Update Count     : 8
//

#ifndef LINKAGESPEC_H
#define LINKAGESPEC_H

#include <string>

struct LinkageSpec {
	enum Spec {
		Intrinsic,										// C built-in defined in prelude
		Cforall,										// ordinary
		C,												// not overloadable, not mangled
		AutoGen,										// built by translator (struct assignment)
		Compiler,										// gcc internal
		NoOfSpecs
	};
  
	static Spec fromString( const std::string & );
	static std::string toString( Spec );
  
	static bool isDecoratable( Spec );
	static bool isGeneratable( Spec );
	static bool isOverridable( Spec );
	static bool isBuiltin( Spec );
};

#endif // LINKAGESPEC_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
