#include <fstream>
#include <monitor>
#include <stdlib>
#include <thread>

#include "bench.h"

coroutine GreatSuspender {};

void ?{}( GreatSuspender * this ) {
	prime(this);
}

void main( GreatSuspender * this )
{
	while( true ) {
		suspend();
	}
}

void resumer( GreatSuspender * this, const unsigned int NoOfTimes ) {
	for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
		resume( this );
	}
}

#ifndef N
#define N 100000000
#endif

//-----------------------------------------------------------------------------
// coroutine context switch
long long int measure_coroutine() {
	const unsigned int NoOfTimes = N;
	long long int StartTime, EndTime;

	GreatSuspender s;

	StartTime = Time();
	// for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
	// 	resume( this_coroutine() );
	// 	// resume( &s );
	// }
	resumer( &s, NoOfTimes );
	EndTime = Time();

	return ( EndTime - StartTime ) / NoOfTimes;
}

//-----------------------------------------------------------------------------
// thread context switch
long long int measure_thread() {
	const unsigned int NoOfTimes = N;
	long long int StartTime, EndTime;

	StartTime = Time();
	for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
		yield();
	}
	EndTime = Time();

	return ( EndTime - StartTime ) / NoOfTimes;
}

//-----------------------------------------------------------------------------
// single monitor entry
monitor mon_t {};
void dummy( mon_t * mutex m ) {}

long long int measure_1_monitor_entry() {
	const unsigned int NoOfTimes = N;
	long long int StartTime, EndTime;
	mon_t mon;

	StartTime = Time();
	for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
		dummy( &mon );
	}
	EndTime = Time();

	return ( EndTime - StartTime ) / NoOfTimes;
}

//-----------------------------------------------------------------------------
// multi monitor entry
void dummy( mon_t * mutex m1,  mon_t * mutex m2 ) {}

long long int measure_2_monitor_entry() {
	const unsigned int NoOfTimes = N;
	long long int StartTime, EndTime;
	mon_t mon1, mon2;

	StartTime = Time();
	for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
		dummy( &mon1, &mon2 );
	}
	EndTime = Time();

	return ( EndTime - StartTime ) / NoOfTimes;
}

int main()
{
	sout | time(NULL) | ',';
	sout | measure_coroutine() | ',';
	sout | measure_thread() | ',';
	sout | measure_1_monitor_entry() | ',';
	sout | measure_2_monitor_entry() | endl;
}
