//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// array.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 18:13:52 2016
// Update Count     : 3
//

#include "array.h"

/// forall( otype array_type, elt_type | bounded_array( array_type, elt_type ) )
/// [ array_iterator begin, array_iterator end ]
/// get_iterators( array_type array )
/// {
///   begin = 0;
///   end = last( array );
/// }

// The first element is always at index 0.
forall( otype array_type, otype elt_type | bounded_array( array_type, elt_type ) )
elt_type * begin( array_type array ) {
	return &array[ 0 ];
}

// The end iterator should point one past the last element.
forall( otype array_type, otype elt_type | bounded_array( array_type, elt_type ) )
elt_type * end( array_type array ) {
	return &array[ last( array ) ] + 1;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa array.c" //
// End: //
