//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// algorithm.c -- 
//
// Author           : Peter A. Buhr
// Created On       : Thu Jan 28 17:10:29 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Feb  5 15:41:24 2016
// Update Count     : 128
//

#include "stdlib"

//---------------------------------------

extern "C" {
#define _XOPEN_SOURCE 600								// posix_memalign, *rand48
#include <stdlib.h>										// malloc, free, calloc, realloc, memalign, posix_memalign, bsearch
#include <string.h>										// memset
#include <malloc.h>										// malloc_usable_size
#include <stdio.h>
#include <math.h>										// fabsf, fabs, fabsl
#include <complex.h>									// _Complex_I, cabsf, cabs, cabsl
} // extern "C"

forall( type T ) T * memset( T * ptr, unsigned char fill ) { // use default value '\0' for fill
	printf( "memset1\n" );
    return (T *)memset( ptr, (int)fill, malloc_usable_size( ptr ) );
} // memset
forall( type T ) T * memset( T * ptr ) {				// remove when default value available
	printf( "memset2\n" );
    return (T *)memset( ptr, 0, malloc_usable_size( ptr ) );
} // memset

forall( type T ) T * malloc( void ) {
	printf( "malloc1\n" );
    return (T *)malloc( sizeof(T) );
} // malloc
forall( type T ) T * malloc( size_t size ) {
	printf( "malloc2\n" );
    return (T *)(void *)malloc( size );
} // malloc
forall( type T ) T * malloc( char fill ) {
	printf( "malloc3\n" );
	T * ptr = (T *)malloc( sizeof(T) );
    return memset( ptr );
} // malloc

forall( type T ) T * calloc( size_t size ) {
	printf( "calloc\n" );
    return (T *)calloc( size, sizeof(T) );
} // calloc

forall( type T ) T * realloc( T * ptr, size_t size ) {
	printf( "realloc1\n" );
    return (T *)(void *)realloc( (void *)ptr, size );
} // realloc
forall( type T ) T * realloc( T * ptr, size_t size, unsigned char fill ) {
	printf( "realloc2\n" );
    char * nptr = (T *)(void *)realloc( (void *)ptr, size );
    size_t unused = malloc_usable_size( nptr );
    memset( nptr + size - unused, (int)fill, unused );	// initialize any new storage
    return nptr;
} // realloc

forall( type T ) T * malloc( T * ptr, size_t size ) {
	printf( "malloc4\n" );
    return (T *)realloc( ptr, size );
} // malloc
forall( type T ) T * malloc( T * ptr, size_t size, unsigned char fill ) {
	printf( "malloc5\n" );
    return (T *)realloc( ptr, size, fill );
} // malloc

forall( type T ) T * aligned_alloc( size_t alignment ) {
	printf( "aligned_alloc\n" );
    return (T *)memalign( alignment, sizeof(T) );
} // aligned_alloc

forall( type T ) T * memalign( size_t alignment ) {
	printf( "memalign\n" );
    return (T *)memalign( alignment, sizeof(T) );
} // memalign

forall( type T ) int posix_memalign( T ** ptr, size_t alignment ) {
	printf( "posix_memalign\n" );
    return posix_memalign( (void **)ptr, alignment, sizeof(T) );
} // posix_memalign

//---------------------------------------

int ato( const char * ptr ) {
	int i;
	if ( sscanf( ptr, "%d", &i ) == EOF ) {}			// check return code
	return i;
}
unsigned int ato( const char * ptr ) {
	unsigned int ui;
	if ( sscanf( ptr, "%u", &ui ) == EOF ) {}			// check return code
	return ui;
}
long int ato( const char * ptr ) {
	long int li;
	if ( sscanf( ptr, "%ld", &li ) == EOF ) {};			// check return code
	return li;
}
unsigned long int ato( const char * ptr ) {
	unsigned long int uli;
	if ( sscanf( ptr, "%lu", &uli ) == EOF ) {};		// check return code
	return uli;
}
long long int ato( const char * ptr ) {
	long long int lli;
	if ( sscanf( ptr, "%lld", &lli ) == EOF ) {};		// check return code
	return lli;
}
unsigned long long int ato( const char * ptr ) {
	unsigned long long int ulli;
	if ( sscanf( ptr, "%llu", &ulli ) == EOF ) {};		// check return code
	return ulli;
}
float ato( const char * ptr ) {
	float f;
	if ( sscanf( ptr, "%f", &f ) == EOF ) {};			// check return code
	return f;
}
double ato( const char * ptr ) {
	double d;
	if ( sscanf( ptr, "%lf", &d ) == EOF ) {};			// check return code
	return d;
}
long double ato( const char * ptr ) {
	long double ld;
	printf( "FRED " );
	if ( sscanf( ptr, "%.32Lf", &ld ) == EOF ) {};		// check return code
	return ld;
}
float _Complex ato( const char * ptr ) {
	float re, im;
	if ( sscanf( ptr, "%g%g", &re, &im ) == EOF ) {};	// check return code
	return re + im * _Complex_I;
}
double _Complex ato( const char * ptr ) {
	double re, im;
	if ( sscanf( ptr, "%.16lg%.16lg", &re, &im ) == EOF ) {}; // check return code
	return re + im * _Complex_I;
}
long double _Complex ato( const char * ptr ) {
	long double re, im;
	if ( sscanf( ptr, "%.32Lg%.32Lg", &re, &im ) == EOF ) {}; // check return code
	return re + im * _Complex_I;
}	

int strto( const char * sptr, char ** eptr, int base ) {
	return (int)strtol( sptr, eptr, base );
}
unsigned int strto( const char * sptr, char ** eptr, int base ) {
	return (unsigned int)strtoul( sptr, eptr, base );
}
long int strto( const char * sptr, char ** eptr, int base ) {
	return strtol( sptr, eptr, base );
}
unsigned long int strto( const char * sptr, char ** eptr, int base ) {
	return strtoul( sptr, eptr, base );
}
long long int strto( const char * sptr, char ** eptr, int base ) {
	return strtoll( sptr, eptr, base );
}
unsigned long long int strto( const char * sptr, char ** eptr, int base ) {
	return strtoull( sptr, eptr, base );
}
float strto( const char * sptr, char ** eptr ) {
	return strtof( sptr, eptr );
}
double strto( const char * sptr, char ** eptr ) {
	return strtod( sptr, eptr );
}
long double strto( const char * sptr, char ** eptr ) {
	return strtold( sptr, eptr );
}
float _Complex strto( const char * sptr, char ** eptr ) {
	float re, im;
	re = strtof( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	im = strtof( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	return re + im * _Complex_I;
}
double _Complex strto( const char * sptr, char ** eptr ) {
	double re, im;
	re = strtod( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	im = strtod( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	return re + im * _Complex_I;
}
long double _Complex strto( const char * sptr, char ** eptr ) {
	long double re, im;
	re = strtold( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	im = strtold( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	return re + im * _Complex_I;
}

//---------------------------------------

forall( type T | { int ?<?( T, T ); } )
T * bsearch( const T key, const T * arr, size_t dimension ) {
	int comp( const void * t1, const void * t2 ) { return *(T *)t1 < *(T *)t2 ? -1 : *(T *)t2 < *(T *)t1 ? 1 : 0; }
	return (T *)bsearch( &key, arr, dimension, sizeof(T), comp );
} // bsearch

forall( type T | { int ?<?( T, T ); } )
void qsort( const T * arr, size_t dimension ) {
	int comp( const void * t1, const void * t2 ) { return *(T *)t1 < *(T *)t2 ? -1 : *(T *)t2 < *(T *)t1 ? 1 : 0; }
	qsort( arr, dimension, sizeof(T), comp );
} // qsort

//---------------------------------------

forall( type T | { T ?/?( T, T ); T ?%?( T, T ); } )
[ T, T ] div( T t1, T t2 ) { /* return [ t1 / t2, t1 % t2 ]; */ }

//---------------------------------------

char abs( char v ) { return abs( (int)v ); }
long int abs( long int v ) { return labs( v ); }
long long int abs( long long int v ) { return llabs( v ); }
float abs( float v ) { return fabsf( v ); }
double abs( double v ) { return fabs( v ); }
long double abs( long double v ) { return fabsl( v ); }
float _Complex abs( float _Complex v ) { return cabsf( v ); }
double _Complex abs( double _Complex v ) { return cabs( v ); }
long double _Complex abs( long double _Complex v ) { return cabsl( v ); }

//---------------------------------------

void randseed( long int s ) { srand48( s ); }
char random() { return lrand48(); }
int random() { return mrand48(); }
unsigned int random() { return lrand48(); }
long int random() { return mrand48(); }
unsigned long int random() { return lrand48(); }
float random() { return (float)drand48(); }				// otherwise float uses lrand48
double random() { return drand48(); }
float _Complex random() { return (float)drand48() + (float _Complex)(drand48() * _Complex_I); }
double _Complex random() { return drand48() + (double _Complex)(drand48() * _Complex_I); }
long double _Complex random() { return (long double)drand48() + (long double _Complex)(drand48() * _Complex_I); }

//---------------------------------------

forall( type T | { int ?<?( T, T ); } )
T min( const T t1, const T t2 ) {
	return t1 < t2 ? t1 : t2;
} // min

forall( type T | { int ?>?( T, T ); } )
T max( const T t1, const T t2 ) {
	return t1 > t2 ? t1 : t2;
} // max

forall( type T )
void swap( T * t1, T * t2 ) {
	T temp = *t1;
	*t1 = *t2;
	*t2 = temp;
} // swap

// Local Variables: //
// tab-width: 4 //
// End: //
