//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// PolyMutator.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Dec 08 15:19:05 2015
// Update Count     : 5
//

#ifndef _POLYMUTATOR_H
#define _POLYMUTATOR_H

#include <map>
#include <string>
#include <list>

#include "GenPoly.h"

#include "SynTree/SynTree.h"
#include "SynTree/Declaration.h"
#include "SynTree/Mutator.h"

namespace GenPoly {
	class PolyMutator : public Mutator {
	  public:
		PolyMutator();

		virtual CompoundStmt* mutate(CompoundStmt *compoundStmt);
		virtual Statement* mutate(IfStmt *ifStmt);
		virtual Statement* mutate(WhileStmt *whileStmt);
		virtual Statement* mutate(ForStmt *forStmt);
		virtual Statement* mutate(SwitchStmt *switchStmt);
		virtual Statement* mutate(ChooseStmt *chooseStmt);
		virtual Statement* mutate(CaseStmt *caseStmt);
		virtual Statement* mutate(TryStmt *returnStmt);
		virtual Statement* mutate(CatchStmt *catchStmt);
		virtual Statement* mutate(ExprStmt *catchStmt);
		virtual Statement* mutate(ReturnStmt *catchStmt);
  
		virtual Expression* mutate(UntypedExpr *untypedExpr);

		virtual Initializer* mutate(SingleInit *SingleInit);

		// template method
		virtual void doBeginScope() {}
		virtual void doEndScope() {}
		
		static void makeTyVarMap( Type *type, TyVarMap &tyVarMap );
	  protected:
		void mutateStatementList( std::list< Statement* > &statements );
		Statement* mutateStatement( Statement *stmt );
		Expression* mutateExpression( Expression *expr );
  
		TyVarMap scopeTyVars;
		TypeSubstitution *env;
		std::list< Statement* > stmtsToAdd;
		std::list< Statement* > stmtsToAddAfter;
	};
} // namespace 

#endif // _POLYMUTATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
