//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FunctionDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Mar 16 08:33:41 2017
// Update Count     : 74
//

#include <cassert>               // for assert
#include <list>                  // for list
#include <ostream>               // for operator<<, ostream, basic_ostream
#include <string>                // for operator<<, string, char_traits, ope...

#include "Attribute.h"           // for Attribute
#include "CodeGen/FixMain.h"     // for FixMain
#include "Common/utility.h"      // for maybeClone, printAll
#include "Declaration.h"         // for FunctionDecl, FunctionDecl::Parent
#include "Parser/LinkageSpec.h"  // for Spec, linkageName, Cforall
#include "Statement.h"           // for CompoundStmt
#include "Type.h"                // for Type, FunctionType, Type::FuncSpecif...

extern bool translation_unit_nomain;

FunctionDecl::FunctionDecl( const std::string &name, Type::StorageClasses scs, LinkageSpec::Spec linkage, FunctionType *type, CompoundStmt *statements, std::list< Attribute * > attributes, Type::FuncSpecifiers fs )
	: Parent( name, scs, linkage, attributes, fs ), type( type ), statements( statements ) {
	// hack forcing the function "main" to have Cforall linkage to replace main even if it is inside an extern
	if ( name == "main" ) {
		set_linkage( CodeGen::FixMain::mainLinkage() );
	} // if
}

FunctionDecl::FunctionDecl( const FunctionDecl &other )
		: Parent( other ), type( maybeClone( other.type ) ), statements( maybeClone( other.statements ) ) {
}

FunctionDecl::~FunctionDecl() {
	delete type;
	delete statements;
}

void FunctionDecl::print( std::ostream &os, int indent ) const {
	using std::endl;
	using std::string;

	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if
	if ( get_linkage() != LinkageSpec::Cforall ) {
		os << LinkageSpec::linkageName( get_linkage() ) << " ";
	} // if

	printAll( get_attributes(), os, indent );

	get_storageClasses().print( os );
	get_funcSpec().print( os );

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if

	if ( statements ) {
		os << string( indent + 2, ' ' ) << "with body " << endl;
		os << string( indent + 4, ' ' );
		statements->print( os, indent + 4 );
	} // if
}

void FunctionDecl::printShort( std::ostream &os, int indent ) const {
	using std::endl;
	using std::string;

	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if

	// xxx - should printShort print attributes?

	get_storageClasses().print( os );
	get_funcSpec().print( os );

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
